/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.api.types;

import com.sdl.context.api.types.GenericVersionPart;
import com.sdl.context.api.types.Version;
import com.sdl.context.api.types.VersionPart;

public class GenericVersion
implements Version {
    private static final int DOUBLE_MINOR_PART_RESOLUTION = 10;
    private static final long serialVersionUID = -9105084549277205530L;
    private String name;
    private GenericVersionPart majorVersionPart;
    private GenericVersionPart minorVersionPart;
    private GenericVersionPart incrementalVersionPart;
    private static final int HASH_CODE_MULTIPLIER = 31;

    public GenericVersion() {
    }

    public GenericVersion(String name) {
        this.setName(name);
        this.init();
    }

    public GenericVersion(int majorVersion) {
        this.setName(String.valueOf(majorVersion));
        this.majorVersionPart = new GenericVersionPart(majorVersion);
    }

    public GenericVersion(int majorVersion, int minorVersion) {
        this.setName(String.valueOf(majorVersion + "." + minorVersion));
        this.majorVersionPart = new GenericVersionPart(majorVersion);
        this.minorVersionPart = new GenericVersionPart(minorVersion);
    }

    public GenericVersion(int majorVersion, int minorVersion, int incrementalVersion) {
        this.setName(String.valueOf(majorVersion + "." + minorVersion + "." + incrementalVersion));
        this.majorVersionPart = new GenericVersionPart(majorVersion);
        this.minorVersionPart = new GenericVersionPart(minorVersion);
        this.incrementalVersionPart = new GenericVersionPart(incrementalVersion);
    }

    public GenericVersion(String majorVersion, String minorVersion) {
        if (majorVersion == null) {
            throw new IllegalStateException("Major version argument for version must not be null");
        }
        this.majorVersionPart = new GenericVersionPart(majorVersion);
        if (minorVersion != null) {
            this.setName(String.valueOf(majorVersion + "." + minorVersion));
            this.minorVersionPart = new GenericVersionPart(minorVersion);
        } else {
            this.setName(String.valueOf(majorVersion));
        }
    }

    public GenericVersion(String majorVersion, String minorVersion, String incrementalVersion) {
        if (majorVersion == null) {
            throw new IllegalStateException("Major version argument for version must not be null");
        }
        this.majorVersionPart = new GenericVersionPart(majorVersion);
        if (minorVersion != null) {
            this.minorVersionPart = new GenericVersionPart(minorVersion);
            if (incrementalVersion != null) {
                this.incrementalVersionPart = new GenericVersionPart(incrementalVersion);
                this.setName(String.valueOf(majorVersion + "." + minorVersion + "." + incrementalVersion));
            } else {
                this.setName(String.valueOf(majorVersion + "." + minorVersion));
            }
        } else {
            this.setName(String.valueOf(majorVersion));
        }
    }

    public GenericVersion(double versionAsDouble) {
        this.setName(String.valueOf(versionAsDouble));
        int majorVersionPartAsInt = (int)versionAsDouble;
        this.majorVersionPart = new GenericVersionPart((int)versionAsDouble);
        long minorVersionPartAsLong = Math.round((versionAsDouble - (double)majorVersionPartAsInt) * 10.0);
        this.minorVersionPart = new GenericVersionPart((int)minorVersionPartAsLong);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = "0".equals(name) ? "" : name;
    }

    private void init() {
        String[] parts = this.name.split("\\.");
        if (parts.length > 0) {
            this.majorVersionPart = new GenericVersionPart(parts[0]);
            if (parts.length > 1) {
                this.minorVersionPart = new GenericVersionPart(parts[1]);
                if (parts.length > 2) {
                    this.incrementalVersionPart = new GenericVersionPart(parts[2]);
                }
            }
        }
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersionPart == null ? 0 : this.minorVersionPart.getNumber();
    }

    @Override
    public String getMinorVersionModifier() {
        return this.minorVersionPart == null ? null : this.minorVersionPart.getModifier();
    }

    @Override
    public int getMinorVersionModifierNumber() {
        return this.minorVersionPart == null ? 0 : this.minorVersionPart.getModifierNumber();
    }

    @Override
    public VersionPart getMinorVersionNamePart() {
        return this.minorVersionPart;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersionPart == null ? 0 : this.majorVersionPart.getNumber();
    }

    @Override
    public String getMajorVersionModifier() {
        return this.majorVersionPart == null ? null : this.majorVersionPart.getModifier();
    }

    @Override
    public int getMajorVersionModifierNumber() {
        return this.majorVersionPart == null ? 0 : this.majorVersionPart.getModifierNumber();
    }

    @Override
    public VersionPart getMajorVersionNamePart() {
        return this.majorVersionPart;
    }

    @Override
    public int getIncrementalVersion() {
        return this.incrementalVersionPart == null ? 0 : this.incrementalVersionPart.getNumber();
    }

    @Override
    public String getIncrementalVersionModifier() {
        return this.incrementalVersionPart == null ? null : this.incrementalVersionPart.getModifier();
    }

    @Override
    public int getIncrementalVersionModifierNumber() {
        return this.incrementalVersionPart == null ? 0 : this.incrementalVersionPart.getModifierNumber();
    }

    @Override
    public VersionPart getIncrementalVersionNamePart() {
        return this.incrementalVersionPart;
    }

    @Override
    public int compareTo(Version versionToCompare) {
        int compare;
        if (this.getMajorVersionNamePart() == null) {
            compare = this.compareVersionPartToNull(versionToCompare.getMajorVersionNamePart());
        } else {
            compare = this.getMajorVersionNamePart().compareTo(versionToCompare.getMajorVersionNamePart());
            if (compare == 0) {
                if (this.getMinorVersionNamePart() == null) {
                    compare = this.compareVersionPartToNull(versionToCompare.getMinorVersionNamePart());
                } else {
                    compare = this.getMinorVersionNamePart().compareTo(versionToCompare.getMinorVersionNamePart());
                    if (compare == 0) {
                        compare = this.getIncrementalVersionNamePart() == null ? this.compareVersionPartToNull(versionToCompare.getIncrementalVersionNamePart()) : this.getIncrementalVersionNamePart().compareTo(versionToCompare.getIncrementalVersionNamePart());
                    }
                }
            }
        }
        return compare;
    }

    private int compareVersionPartToNull(VersionPart versionPartToCompare) {
        return this.isEqualToNull(versionPartToCompare) ? 0 : -1;
    }

    private boolean isEqualToNull(VersionPart versionPartToCompare) {
        if (versionPartToCompare == null) {
            return true;
        }
        return versionPartToCompare.getNumber() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericVersion version = (GenericVersion)o;
        if (this.majorVersionPart == null ? !this.isEqualToNull(version.majorVersionPart) : !this.majorVersionPart.equals(version.majorVersionPart)) {
            return false;
        }
        if (this.minorVersionPart == null ? !this.isEqualToNull(version.minorVersionPart) : !this.minorVersionPart.equals(version.minorVersionPart)) {
            return false;
        }
        return !(this.incrementalVersionPart == null ? !this.isEqualToNull(version.incrementalVersionPart) : !this.incrementalVersionPart.equals(version.incrementalVersionPart));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.majorVersionPart != null ? this.majorVersionPart.hashCode() : 0);
        result = 31 * result + (this.minorVersionPart != null ? this.minorVersionPart.hashCode() : 0);
        result = 31 * result + (this.incrementalVersionPart != null ? this.incrementalVersionPart.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(String versionToCompareAsString) {
        return this.compareTo(new GenericVersion(versionToCompareAsString));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public GenericVersion coerce(Object object) {
        if (object instanceof String) {
            return new GenericVersion((String)object);
        }
        if (object instanceof Integer || object instanceof Double || object instanceof Float || object instanceof Long) {
            return new GenericVersion(String.valueOf(object));
        }
        if (object instanceof GenericVersion) {
            return (GenericVersion)object;
        }
        throw new RuntimeException("Cannot coerce object " + object + " into " + GenericVersion.class);
    }
}

