/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context;

import java.util.regex.Pattern;

public final class Constants {
    private Constants() {
    }

    public static final class Translation {
        public static final String CONFIGURATION_ENTRY_LOCATION = "resolvers.translation.translators";

        private Translation() {
        }
    }

    public static final class Evidence {
        private Evidence() {
        }

        public static final class Origin {
            public static final String HTTP = "http";
            public static final String ADF = "adf";
            public static final String CONTEXT = "context";
            public static final String TARGET_GROUP = "target-group";

            private Origin() {
            }
        }

        public static final class EvidenceName {
            public static final String COOKIE = "cookie";
            public static final String USER_AGENT = "user-agent";
            public static final String ADF_URI = "adf-uri";
            public static final String PUBLICATION_ID = "publication-id";

            private EvidenceName() {
            }
        }
    }

    public static final class LevensteinDistance {
        public static final int DEFAULT_ACCEPTABLE_DISTANCE = 30;
        public static final int ACCEPTABLE_DISTANCE_NOT_SET = -1;
        public static final int MAX_NOT_FOUND_BETTER_COUNT = 40;

        private LevensteinDistance() {
        }
    }

    public static final class Context {
        public static final String REPOSITORY_SOURCE_LOCATION = "update.directory";
        public static final String UPDATE_FILTER_LOCATION = "update.filters.directory";
        public static final String IMPORT_IDS = "repository:importIds";
        public static final String META_FINAL = "repository:final";
        public static final String META_MERGED_INTO_EXISTING = "repository:mergedIntoExisting";
        public static final String META_IMPORT_URI = "repository:importUri";
        public static final String REPOSITORY_LOCATION = "repository.location";
        public static final String RECREATE_DB = "recreate.db.flag";
        public static final String REPOSITORY_READ_ONLY = "repository.readOnly";
        public static final String REPOSITORY_TYPE = "repository.type";
        public static final int MINIMUM_TRUST = 0;
        public static final int NOT_SET_TRUST_LEVEL = 5;
        public static final int CONTEXT_EVIDENCE_PRESET_TRUST = 90;
        public static final int DEFAULT_TRUST_LEVEL = 2;
        public static final int JUST_INHERITANCE_TRUST_LEVEL = 1;
        public static final String IGNORE_IDENTIFIERS_ON_MERGE = "ignoreIdentifiersOnMerge";
        public static final int AVERAGE_TRUST = 50;
        public static final int HIGH_TRUST = 80;
        public static final int MAXIMUM_TRUST = 100;
        public static final String SOURCE_BUILD_ID = "source.buildId";
        public static final String VARIANT_IMPORT_ID_START = "importId|";
        public static final int INTEGER_VALUE_NOT_SET = -1;
        public static final String START_NON_LEVENSTEIN_TRIE_SELECT_CONTEXT_MAP_MESSAGE = "Before - trie select (non levenstein)";
        public static final Pattern START_NON_LEVENSTEIN_TRIE_SELECT_CONTEXT_MAP_MESSAGE_PATTERN = Pattern.compile("Before - trie select (non levenstein)");
        public static final String END_NON_LEVENSTEIN_TRIE_SELECT_CONTEXT_MAP_MESSAGE = "After - trie select (non levenstein)";
        public static final Pattern END_NON_LEVENSTEIN_TRIE_SELECT_CONTEXT_MAP_MESSAGE_PATTERN = Pattern.compile("After - trie select (non levenstein)");
        public static final String START_LEVENSTEIN_TRIE_SELECT_CONTEXT_MAP_MESSAGE = "Before - trie select with levenstein distance";
        public static final Pattern START_LEVENSTEIN_TRIE_SELECT_CONTEXT_MAP_MESSAGE_PATTERN = Pattern.compile("Before - trie select with levenstein distance");
        public static final String END_LEVENSTEIN_TRIE_SELECT_CONTEXT_MAP_MESSAGE = "After - trie select with levenstein distance";
        public static final Pattern END_LEVENSTEIN_TRIE_SELECT_CONTEXT_MAP_MESSAGE_PATTERN = Pattern.compile("After - trie select with levenstein distance");
        public static final String START_GET_CONTEXT_MAP_MESSAGE = "Before - getting flattened context map for ID \"%s\"";
        public static final Pattern START_GET_CONTEXT_MAP_MESSAGE_PATTERN = Pattern.compile(String.format("Before - getting flattened context map for ID \"%s\"", "(.*)"));
        public static final String END_GET_CONTEXT_MAP_MESSAGE = "After - getting flattened context map for ID \"%s\"";
        public static final Pattern END_GET_CONTEXT_MAP_MESSAGE_PATTERN = Pattern.compile(String.format("After - getting flattened context map for ID \"%s\"", "(.*)"));
        public static final String START_BUCKET_MESSAGE = "> Start bucket \"%s\"";
        public static final Pattern START_BUCKET_MESSAGE_PATTERN = Pattern.compile(String.format("> Start bucket \"%s\"", "(.*)"));
        public static final String END_BUCKET_MESSAGE = "< End bucket \"%s\"";
        public static final Pattern END_BUCKET_MESSAGE_PATTERN = Pattern.compile(String.format("< End bucket \"%s\"", "(.*)"));
        public static final String CONTEXT_MAP_ID_MESSAGE = "context map {%s}";
        public static final Pattern CONTEXT_MAP_ID_MESSAGE_PATTERN = Pattern.compile(String.format("context map {%s}", "(.*)").replace("{", "\\{").replace("}", "\\}"));

        private Context() {
        }
    }

    public static final class Persistence {
        public static final int BUILD_ID_LENGTH = 8;
        public static final int ID_LENGTH = 32;
        public static final int NAME_LENGTH = 50;
        public static final int VALUE_LENGTH = 125;
        public static final int SHORT_TEXT_LENGTH = 255;
        public static final int LABEL_LENGTH = 512;
        public static final int EXPRESSION_LENGTH = 50;

        private Persistence() {
        }
    }

    public static final class Naming {
        private Naming() {
        }

        public static final class Vocabulary {
            public static final String PROPERTY_NAME_DELIMITER = ".";

            private Vocabulary() {
            }
        }
    }

    public static final class Http {
        public static final String HEADER_BUILD_ID = "X-Context-Build-Id";
        public static final String HEADER_REPOSITORY_RELEASE_ID = "X-Context-Repository-Release";
        @Deprecated
        public static final String HEADER_SERVICE_BUILD_ID = "x-context-service-build-id";

        private Http() {
        }
    }

    public static final class Default {
        public static final String COMMONS_CONFIG_FILE = "cwd_engine_commons_conf.xml";
        public static final String CUSTOM_CONFIG_FILE = "cwd_engine_conf.xml";
        public static final String SYSTEM_REPOSITORY_INITIALISATION_URI = "classpath:com/sdl/context/engine/repository/config/initialisation.xml";
        public static final String SYSTEM_BUCKETS_URI = "classpath:com/sdl/context/engine/repository/config/buckets.xml";
        public static final String SYSTEM_VOCABULARY_URI = "classpath:com/sdl/context/engine/repository/config/vocabulary.xml";
        public static final String CUSTOM_VOCABULARY_RELATIVE_URI = "cwd_engine_vocabulary_conf.xml";
        public static final String CUSTOM_VOCABULARY_URI = "classpath:cwd_engine_vocabulary_conf.xml";
        public static final String REPOSITORY_DIRECTORY = "../repository";
        public static final int SAMPLING_INTERVAL = 10;
        public static final int MIN_EXPRESSION_TRUST = 0;
        public static final int MAX_EXPRESSION_TRUST = 100;
        public static final int DISCOVER_TRUST = 85;
        public static final int DEFAULT_CONNECTION_TIME_OUT = 10000;
        public static final int DEFAULT_READ_TIME_OUT = 60000;
        public static final String DEFAULT_ENCODING = "UTF-8";

        private Default() {
        }
    }

    public static final class Property {
        public static final String META_DATA_SOURCE_VOCAB_KEY = "translation:vocabulary";

        private Property() {
        }
    }
}

