/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.api.resolution;

import com.sdl.context.api.resolution.Evidence;
import com.sdl.context.api.resolution.EvidenceItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class HierarchicalEvidence
implements Evidence {
    private Evidence parent;
    private Map<String, EvidenceItem> child;
    private Set<String> origins;

    HierarchicalEvidence(Evidence parent, Map<String, EvidenceItem> child, Set<String> origins) {
        this.parent = parent;
        this.child = child;
        this.origins = origins;
    }

    @Override
    public EvidenceItem get(String key) {
        EvidenceItem evidenceValue = this.child.get(key);
        if (evidenceValue == null) {
            evidenceValue = this.parent.get(key);
        }
        return evidenceValue;
    }

    @Override
    public boolean containsKey(String key) {
        return this.child.containsKey(key) || this.parent.containsKey(key);
    }

    @Override
    public boolean containsOrigin(String origin) {
        return this.origins.contains(origin) || this.parent.containsOrigin(origin);
    }

    @Override
    public Iterator<EvidenceItem> iterator() {
        ArrayList<EvidenceItem> items = new ArrayList<EvidenceItem>(this.child.values());
        if (this.parent != null) {
            for (EvidenceItem evidenceItem : this.parent) {
                items.add(evidenceItem);
            }
        }
        return items.iterator();
    }
}

