/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.model;

import com.sdl.context.api.types.Version;
import com.sdl.context.api.types.VersionPart;
import com.sdl.context.odata.model.ODataVersionPart;
import com.sdl.odata.api.edm.annotations.EdmComplex;
import com.sdl.odata.api.edm.annotations.EdmProperty;

@EdmComplex(namespace="ODataContextualDelivery")
public class ODataVersion
implements Version {
    private static final int DOUBLE_MINOR_PART_RESOLUTION = 10;
    private static final long serialVersionUID = -9105081549277205530L;
    private static final int HASH_CODE_MULTIPLIER = 37;
    @EdmProperty
    private String name;
    @EdmProperty
    private ODataVersionPart majorVersionPart;
    @EdmProperty
    private ODataVersionPart minorVersionPart;
    @EdmProperty
    private ODataVersionPart incrementalVersionPart;

    public ODataVersionPart getMajorVersionPart() {
        return this.majorVersionPart;
    }

    public void setMajorVersionPart(ODataVersionPart majorVersionPart) {
        this.majorVersionPart = majorVersionPart;
    }

    public ODataVersionPart getMinorVersionPart() {
        return this.minorVersionPart;
    }

    public void setMinorVersionPart(ODataVersionPart minorVersionPart) {
        this.minorVersionPart = minorVersionPart;
    }

    public ODataVersionPart getIncrementalVersionPart() {
        return this.incrementalVersionPart;
    }

    public void setIncrementalVersionPart(ODataVersionPart incrementalVersionPart) {
        this.incrementalVersionPart = incrementalVersionPart;
    }

    public ODataVersion() {
    }

    public ODataVersion(String name) {
        this.setName(name);
        this.init();
    }

    public ODataVersion(int majorVersion) {
        this.setName(String.valueOf(majorVersion));
        this.majorVersionPart = new ODataVersionPart(majorVersion);
    }

    public ODataVersion(int majorVersion, int minorVersion) {
        this.setName(String.valueOf(majorVersion + "." + minorVersion));
        this.majorVersionPart = new ODataVersionPart(majorVersion);
        this.minorVersionPart = new ODataVersionPart(minorVersion);
    }

    public ODataVersion(int majorVersion, int minorVersion, int incrementalVersion) {
        this.setName(String.valueOf(majorVersion + "." + minorVersion + "." + incrementalVersion));
        this.majorVersionPart = new ODataVersionPart(majorVersion);
        this.minorVersionPart = new ODataVersionPart(minorVersion);
        this.incrementalVersionPart = new ODataVersionPart(incrementalVersion);
    }

    public ODataVersion(String majorVersion, String minorVersion) {
        if (majorVersion == null) {
            throw new IllegalStateException("Major version argument for version must not be null");
        }
        this.majorVersionPart = new ODataVersionPart(majorVersion);
        if (minorVersion != null) {
            this.setName(String.valueOf(majorVersion + "." + minorVersion));
            this.minorVersionPart = new ODataVersionPart(minorVersion);
        } else {
            this.setName(String.valueOf(majorVersion));
        }
    }

    public ODataVersion(String majorVersion, String minorVersion, String incrementalVersion) {
        if (majorVersion == null) {
            throw new IllegalStateException("Major version argument for version must not be null");
        }
        this.majorVersionPart = new ODataVersionPart(majorVersion);
        if (minorVersion != null) {
            this.minorVersionPart = new ODataVersionPart(minorVersion);
            if (incrementalVersion != null) {
                this.incrementalVersionPart = new ODataVersionPart(incrementalVersion);
                this.setName(String.valueOf(majorVersion + "." + minorVersion + "." + incrementalVersion));
            } else {
                this.setName(String.valueOf(majorVersion + "." + minorVersion));
            }
        } else {
            this.setName(String.valueOf(majorVersion));
        }
    }

    public ODataVersion(double versionAsDouble) {
        this.setName(String.valueOf(versionAsDouble));
        int majorVersionPartAsInt = (int)versionAsDouble;
        this.majorVersionPart = new ODataVersionPart((int)versionAsDouble);
        long minorVersionPartAsLong = Math.round((versionAsDouble - (double)majorVersionPartAsInt) * 10.0);
        this.minorVersionPart = new ODataVersionPart((int)minorVersionPartAsLong);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = "0".equals(name) ? "" : name;
    }

    private void init() {
        String[] parts = this.name.split("\\.");
        if (parts.length > 0) {
            this.majorVersionPart = new ODataVersionPart(parts[0]);
            if (parts.length > 1) {
                this.minorVersionPart = new ODataVersionPart(parts[1]);
                if (parts.length > 2) {
                    this.incrementalVersionPart = new ODataVersionPart(parts[2]);
                }
            }
        }
    }

    public int getMinorVersion() {
        return this.minorVersionPart == null ? 0 : this.minorVersionPart.getNumber();
    }

    public String getMinorVersionModifier() {
        return this.minorVersionPart == null ? null : this.minorVersionPart.getModifier();
    }

    public int getMinorVersionModifierNumber() {
        return this.minorVersionPart == null ? 0 : this.minorVersionPart.getModifierNumber();
    }

    public VersionPart getMinorVersionNamePart() {
        return this.minorVersionPart;
    }

    public int getMajorVersion() {
        return this.majorVersionPart == null ? 0 : this.majorVersionPart.getNumber();
    }

    public String getMajorVersionModifier() {
        return this.majorVersionPart == null ? null : this.majorVersionPart.getModifier();
    }

    public int getMajorVersionModifierNumber() {
        return this.majorVersionPart == null ? 0 : this.majorVersionPart.getModifierNumber();
    }

    public VersionPart getMajorVersionNamePart() {
        return this.majorVersionPart;
    }

    public int getIncrementalVersion() {
        return this.incrementalVersionPart == null ? 0 : this.incrementalVersionPart.getNumber();
    }

    public String getIncrementalVersionModifier() {
        return this.incrementalVersionPart == null ? null : this.incrementalVersionPart.getModifier();
    }

    public int getIncrementalVersionModifierNumber() {
        return this.incrementalVersionPart == null ? 0 : this.incrementalVersionPart.getModifierNumber();
    }

    public VersionPart getIncrementalVersionNamePart() {
        return this.incrementalVersionPart;
    }

    public int compareTo(Version versionToCompare) {
        int compare;
        if (this.getMajorVersionNamePart() == null) {
            compare = this.compareVersionPartToNull(versionToCompare.getMajorVersionNamePart());
        } else {
            compare = this.getMajorVersionNamePart().compareTo((Object)versionToCompare.getMajorVersionNamePart());
            if (compare == 0) {
                if (this.getMinorVersionNamePart() == null) {
                    compare = this.compareVersionPartToNull(versionToCompare.getMinorVersionNamePart());
                } else {
                    compare = this.getMinorVersionNamePart().compareTo((Object)versionToCompare.getMinorVersionNamePart());
                    if (compare == 0) {
                        compare = this.getIncrementalVersionNamePart() == null ? this.compareVersionPartToNull(versionToCompare.getIncrementalVersionNamePart()) : this.getIncrementalVersionNamePart().compareTo((Object)versionToCompare.getIncrementalVersionNamePart());
                    }
                }
            }
        }
        return compare;
    }

    private int compareVersionPartToNull(VersionPart versionPartToCompare) {
        return this.isEqualToNull(versionPartToCompare) ? 0 : -1;
    }

    private boolean isEqualToNull(VersionPart versionPartToCompare) {
        if (versionPartToCompare == null) {
            return true;
        }
        return versionPartToCompare.getNumber() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODataVersion version = (ODataVersion)o;
        if (this.majorVersionPart == null ? !this.isEqualToNull(version.majorVersionPart) : !this.majorVersionPart.equals(version.majorVersionPart)) {
            return false;
        }
        if (this.minorVersionPart == null ? !this.isEqualToNull(version.minorVersionPart) : !this.minorVersionPart.equals(version.minorVersionPart)) {
            return false;
        }
        return !(this.incrementalVersionPart == null ? !this.isEqualToNull(version.incrementalVersionPart) : !this.incrementalVersionPart.equals(version.incrementalVersionPart));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 37 * result + (this.majorVersionPart != null ? this.majorVersionPart.hashCode() : 0);
        result = 37 * result + (this.minorVersionPart != null ? this.minorVersionPart.hashCode() : 0);
        result = 37 * result + (this.incrementalVersionPart != null ? this.incrementalVersionPart.hashCode() : 0);
        return result;
    }

    public int compareTo(String versionToCompareAsString) {
        return this.compareTo(new ODataVersion(versionToCompareAsString));
    }

    public String toString() {
        return this.name;
    }

    public ODataVersion coerce(Object object) {
        if (object instanceof String) {
            return new ODataVersion((String)object);
        }
        if (object instanceof Integer || object instanceof Double || object instanceof Float || object instanceof Long) {
            return new ODataVersion(String.valueOf(object));
        }
        if (object instanceof ODataVersion) {
            return (ODataVersion)object;
        }
        throw new RuntimeException("Cannot coerce object " + object + " into " + ODataVersion.class);
    }
}

