/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.model;

import com.sdl.context.api.types.VersionPart;
import com.sdl.odata.api.edm.annotations.EdmComplex;
import com.sdl.odata.api.edm.annotations.EdmProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@EdmComplex(namespace="ODataContextualDelivery")
public class ODataVersionPart
implements VersionPart {
    private static final int HASH_CODE_MULTIPLIER = 31;
    private static final Pattern NUMBER_EXTRACTION_PATTERN = Pattern.compile("([\\-]?[0-9,]+)[0-9]*?[-]?([^0-9]*)([0-9]*)");
    private static final int MODIFIER_NUMBER_GROUP = 3;
    private static final long serialVersionUID = -1303966792707162896L;
    private static final Map<String, Integer> MODIFIER_PRIORITIES = new HashMap<String, Integer>();
    private static final int MODIFIER_EMPTY_PRIORITY;
    @EdmProperty(nullable=false)
    private int number = 0;
    @EdmProperty
    private String modifier;
    @EdmProperty(nullable=false)
    private int modifierNumber = 0;
    @EdmProperty(nullable=false)
    private int modifierPriority = 0;

    public ODataVersionPart() {
    }

    public ODataVersionPart(String part) {
        this.init(part);
    }

    public ODataVersionPart(int partAsInteger) {
        this.number = partAsInteger;
        this.modifierPriority = MODIFIER_EMPTY_PRIORITY;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public int getModifierNumber() {
        return this.modifierNumber;
    }

    public void setModifierNumber(int modifierNumber) {
        this.modifierNumber = modifierNumber;
    }

    public int getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(int modifierPriority) {
        this.modifierPriority = modifierPriority;
    }

    private void init(String part) {
        Matcher matcher = NUMBER_EXTRACTION_PATTERN.matcher(part);
        if (matcher.matches()) {
            String firstPart = matcher.group(1);
            String[] firstPartPortions = firstPart.split(",");
            this.number = Integer.parseInt(firstPartPortions[0]);
            this.modifier = matcher.group(2);
            Integer modifierPriorityCandidate = MODIFIER_PRIORITIES.get(this.modifier);
            if (modifierPriorityCandidate != null) {
                this.modifierPriority = modifierPriorityCandidate;
            }
            if (this.modifier.length() == 0) {
                this.modifier = null;
            }
            if (matcher.group(3).length() > 0) {
                this.modifierNumber = Integer.parseInt(matcher.group(3));
            }
        } else {
            this.modifierPriority = MODIFIER_EMPTY_PRIORITY;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return this.number == 0;
        }
        ODataVersionPart that = (ODataVersionPart)o;
        if (this.modifierNumber != that.modifierNumber) {
            return false;
        }
        if (this.modifierPriority != that.modifierPriority) {
            return false;
        }
        if (this.number != that.number) {
            return false;
        }
        return !(this.modifier != null ? !this.modifier.equals(that.modifier) : that.modifier != null);
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + (this.modifier != null ? this.modifier.hashCode() : 0);
        result = 31 * result + this.modifierNumber;
        result = 31 * result + this.modifierPriority;
        return result;
    }

    public int compareTo(VersionPart versionNamePart) {
        int compare;
        if (versionNamePart == null) {
            compare = this.number == 0 ? 0 : 1;
        } else if (this.getNumber() < versionNamePart.getNumber()) {
            compare = -1;
        } else if (this.getNumber() > versionNamePart.getNumber()) {
            compare = 1;
        } else if (this.modifierPriority == 0 && this.modifierNumber == 0) {
            compare = versionNamePart.getModifierPriority() == 0 && versionNamePart.getModifierNumber() == 0 ? 0 : 1;
        } else if (versionNamePart.getModifierPriority() == 0 && versionNamePart.getModifierNumber() == 0) {
            compare = -1;
        } else {
            compare = this.modifierPriority - versionNamePart.getModifierPriority();
            if (compare == 0) {
                compare = this.modifierNumber - versionNamePart.getModifierNumber();
            }
        }
        return compare;
    }

    public String toString() {
        return this.number + (this.modifier == null ? "" : this.modifier + (this.modifierNumber > 0 ? String.valueOf(this.modifierNumber) : ""));
    }

    static {
        int i = 0;
        for (String modifier : new String[]{"m", "b", "rc", "", "SNAPSHOT"}) {
            MODIFIER_PRIORITIES.put(modifier, ++i);
        }
        MODIFIER_EMPTY_PRIORITY = MODIFIER_PRIORITIES.get("");
    }
}

