/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.model.adapter;

import com.sdl.context.api.ContextVocabulary;
import com.sdl.context.api.definition.AspectDefinition;
import com.sdl.context.api.definition.ContextPropertyDefinition;
import com.sdl.context.api.definition.ContextPropertyName;
import com.sdl.context.api.definition.GenericContextPropertyName;
import com.sdl.context.api.exception.VocabularyException;
import com.sdl.context.odata.model.ODataContextAspectDefinition;
import com.sdl.context.odata.model.ODataContextPropertyDefinition;
import com.sdl.context.odata.model.ODataContextVocabulary;
import com.sdl.context.odata.model.adapter.ODataContextAspectDefinitionAdapter;
import com.sdl.context.odata.model.adapter.ODataContextPropertyDefinitionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ODataContextVocabularyAdapter
implements ContextVocabulary {
    private ODataContextVocabulary contextVocabulary;
    private Map<String, ODataContextAspectDefinition> aspectDefinitions = new HashMap<String, ODataContextAspectDefinition>();

    public ODataContextVocabularyAdapter(ODataContextVocabulary contextVocabulary) {
        this.contextVocabulary = contextVocabulary;
    }

    public Set<String> keySet() {
        this.initializeAspectDefinitionsIfNeeded();
        return this.aspectDefinitions.keySet();
    }

    private void initializeAspectDefinitionsIfNeeded() {
        if (this.aspectDefinitions.isEmpty() && !this.contextVocabulary.getPropertyDefinitions().isEmpty()) {
            for (ODataContextPropertyDefinition propertyDefinition : this.contextVocabulary.getPropertyDefinitions()) {
                if (propertyDefinition.getAspectName() == null && propertyDefinition.getPropertyName() == null) continue;
                ODataContextAspectDefinition aspectDefinition = this.aspectDefinitions.get(propertyDefinition.getAspectName());
                if (aspectDefinition == null) {
                    aspectDefinition = new ODataContextAspectDefinition();
                    aspectDefinition.setAspectName(propertyDefinition.getAspectName());
                    this.aspectDefinitions.put(aspectDefinition.getAspectName(), aspectDefinition);
                }
                aspectDefinition.getPropertyDefinitions().add(propertyDefinition);
            }
        }
    }

    public String getId() {
        return this.contextVocabulary.getId();
    }

    public AspectDefinition get(String aspectName) {
        this.initializeAspectDefinitionsIfNeeded();
        return new ODataContextAspectDefinitionAdapter(this.aspectDefinitions.get(aspectName));
    }

    public ContextPropertyDefinition findPropertyDefinition(String aspectName, String localPropertyName) throws VocabularyException {
        return this.findPropertyDefinition((ContextPropertyName)new GenericContextPropertyName(aspectName, localPropertyName));
    }

    public ContextPropertyDefinition findPropertyDefinition(ContextPropertyName name) throws VocabularyException {
        this.initializeAspectDefinitionsIfNeeded();
        return new ODataContextAspectDefinitionAdapter(this.aspectDefinitions.get(name.getAspectName())).get(name.getLocalPropertyName());
    }

    public List<ContextPropertyDefinition> getPropertyDefinitions() {
        ArrayList<ContextPropertyDefinition> propertyDefinitions = new ArrayList<ContextPropertyDefinition>();
        for (ODataContextPropertyDefinition oDataPropertyDefinition : this.contextVocabulary.getPropertyDefinitions()) {
            if (oDataPropertyDefinition.getAspectName() == null || oDataPropertyDefinition.getPropertyName() == null) continue;
            propertyDefinitions.add(new ODataContextPropertyDefinitionAdapter(oDataPropertyDefinition));
        }
        return propertyDefinitions;
    }
}

