/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sdl.context.api.resolution.Evidence;
import com.sdl.context.api.resolution.EvidenceBuilder;
import com.sdl.context.api.resolution.EvidenceItem;
import com.sdl.context.odata.serialization.EvidenceDto;
import com.sdl.context.odata.serialization.ResolveEvidenceKey;
import java.io.IOException;
import java.util.ArrayList;

public class EvidenceSerializer {
    private ObjectMapper objectMapper = new ObjectMapper();

    public String serialize(Evidence evidence) throws JsonProcessingException {
        ArrayList<EvidenceDto> evidenceDtoList = new ArrayList<EvidenceDto>();
        for (EvidenceItem evidenceItem : evidence) {
            String key = evidenceItem.getKey();
            String value = evidenceItem.getValue() == null ? null : evidenceItem.getValue().toString();
            evidenceDtoList.add(new EvidenceDto(key, value, evidenceItem.getOrigin()));
        }
        return this.objectMapper.writeValueAsString(evidenceDtoList);
    }

    public Evidence deSerialize(String serializedEvidenceList) throws IOException {
        ResolveEvidenceKey evidenceList = (ResolveEvidenceKey)this.objectMapper.readValue(serializedEvidenceList, ResolveEvidenceKey.class);
        EvidenceBuilder builder = new EvidenceBuilder();
        for (EvidenceDto evidenceDto : evidenceList) {
            builder.with(evidenceDto.getKey(), (Object)evidenceDto.getValue(), evidenceDto.getOrigin());
        }
        return builder.build();
    }
}

