/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.index.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sdl.delivery.iq.index.api.data.BaseEntity;
import com.sdl.delivery.iq.index.api.data.EntityField;
import com.sdl.delivery.iq.index.models.IndexField;
import com.sdl.delivery.iq.index.sourcemodels.ish.ModelUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public abstract class AbstractEntity
implements BaseEntity {
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="name", required=true)
    private String entityName;
    @JsonProperty(value="itemType", required=true)
    private String itemType;
    @JsonProperty(value="fields", required=true)
    private List<EntityField> fields = new LinkedList<EntityField>();
    @JsonProperty(value="locale")
    private Locale locale;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="modifiedDate")
    private String modifiedDate;
    @JsonProperty(value="majorVersion")
    private String majorVersion;
    @JsonProperty(value="minorVersion")
    private String minorVersion;
    @JsonProperty(value="publicationId")
    private Integer publicationId;
    @JsonProperty(value="namespace")
    private String namespace;

    public void setId(String key) {
        this.id = key;
    }

    public String getId() {
        return this.id;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setLocale(Locale locale) {
        if (ModelUtils.isValidLocale(locale)) {
            this.locale = locale;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    @JsonDeserialize(contentAs=IndexField.class)
    public void setFields(List<EntityField> fields) {
        this.fields = fields;
    }

    public List<EntityField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public void addField(EntityField field) {
        this.fields.add(field);
    }

    public Optional<EntityField> getField(String fieldName) {
        if (fieldName == null) {
            return Optional.empty();
        }
        return this.fields.stream().filter(f -> fieldName.equals(f.getFieldName())).findFirst();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(String majorVersion) {
        this.majorVersion = majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(String minorVersion) {
        this.minorVersion = minorVersion;
    }

    public Integer getPublicationId() {
        return this.publicationId;
    }

    public void setPublicationId(Integer publicationId) {
        this.publicationId = publicationId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

