/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.index.provider;

import com.sdl.delivery.iq.index.api.data.Mapping;
import com.sdl.delivery.iq.index.api.provider.IndexResult;
import com.sdl.delivery.iq.index.api.provider.IndexResultParser;
import com.sdl.delivery.iq.index.api.provider.results.DocumentCreateUpdateResult;
import com.sdl.delivery.iq.index.api.provider.results.DocumentRemoveResult;
import com.sdl.delivery.iq.index.api.provider.results.EntityMappingCreateResult;
import com.sdl.delivery.iq.index.api.provider.results.EntityMappingGetResult;
import com.sdl.delivery.iq.index.api.provider.results.EntityMappingModifyResult;
import com.sdl.delivery.iq.index.api.provider.results.EntityMappingRemoveResult;
import com.sdl.delivery.iq.index.api.provider.results.IndexRemoveResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class DefaultIndexResultParser
implements IndexResultParser {
    public Function<IndexResult<DocumentCreateUpdateResult>, String> documentLocationParser() {
        return result -> ((DocumentCreateUpdateResult)result.getResultObject()).getLocation();
    }

    public Function<IndexResult<DocumentCreateUpdateResult>, Boolean> documentIsCreatedParser() {
        return result -> ((DocumentCreateUpdateResult)result.getResultObject()).isCreated();
    }

    public Function<IndexResult<? extends DocumentRemoveResult>, Boolean> documentIsDeletedParser() {
        return result -> ((DocumentRemoveResult)result.getResultObject()).isDeleted();
    }

    public Function<IndexResult<EntityMappingCreateResult>, String> entityMappingLocationParser() {
        return result -> ((EntityMappingCreateResult)result.getResultObject()).getLocation();
    }

    public Function<IndexResult<EntityMappingCreateResult>, Boolean> entityMappingIsExistsParser() {
        return result -> ((EntityMappingCreateResult)result.getResultObject()).isExists();
    }

    public Function<IndexResult<EntityMappingModifyResult>, Boolean> entityMappingIsModifiedParser() {
        return result -> ((EntityMappingModifyResult)result.getResultObject()).isModified();
    }

    public Function<IndexResult<EntityMappingGetResult>, Optional<List<Mapping>>> entityMappingListParser() {
        return result -> ((EntityMappingGetResult)result.getResultObject()).getEntityMappings();
    }

    public Function<IndexResult<EntityMappingRemoveResult>, Boolean> entityMappingIsNotExistsParser() {
        return result -> ((EntityMappingRemoveResult)result.getResultObject()).isNotExists();
    }

    public Function<IndexResult<EntityMappingRemoveResult>, Boolean> entityMappingIsNotEmptyParser() {
        return result -> ((EntityMappingRemoveResult)result.getResultObject()).isNotEmpty();
    }

    public Function<IndexResult<EntityMappingRemoveResult>, Boolean> entityMappingIsDeletedParser() {
        return result -> ((EntityMappingRemoveResult)result.getResultObject()).isDeletedIndex();
    }

    public Function<IndexResult<EntityMappingRemoveResult>, Boolean> entityMappingIsCreatedParser() {
        return result -> ((EntityMappingRemoveResult)result.getResultObject()).isCreatedMappings();
    }

    public Function<IndexResult<IndexRemoveResult>, Boolean> indexIsNotEmptyParser() {
        return result -> ((IndexRemoveResult)result.getResultObject()).isNotEmpty();
    }
}

