/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.index.sourcemodels.ish;

import com.sdl.delivery.iq.index.sourcemodels.ish.ModelUtils;

public class IndexedIshContent {
    private Object content;
    private ContentType contentType;

    public IndexedIshContent(String content) {
        this(content, ContentType.PLAIN);
    }

    public IndexedIshContent(String content, ContentType type) {
        this.contentType = type;
        switch (type) {
            case PLAIN: {
                this.content = ModelUtils.stripNewlines(ModelUtils.stripControlCharacters(content));
                break;
            }
            case BASE64: {
                this.content = content;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)type));
            }
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return (String)this.content;
    }

    public static enum ContentType {
        PLAIN,
        BASE64;

    }
}

