/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.index.sourcemodels.ish;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.sdl.delivery.configuration.utils.ConditionUtil;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;

public class IshMetadataPropertyType {
    private Class type;
    private boolean searchable;
    private Class arrayItemType;

    public Class getType() {
        return this.type;
    }

    @JsonSetter(value="type")
    public void setType(String type) {
        if (ConditionUtil.isNullOrEmpty((String)type)) {
            return;
        }
        this.type = this.parseItemType(type);
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    @JsonSetter(value="searchable")
    public void setSearchable(String searchable) {
        if (ConditionUtil.isNullOrEmpty((String)searchable) || searchable.equalsIgnoreCase("no")) {
            this.searchable = false;
        }
        if (searchable.equalsIgnoreCase("yes")) {
            this.searchable = true;
        }
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public Class getArrayItemType() {
        return this.arrayItemType;
    }

    @JsonSetter(value="items")
    public void setArrayItemType(LinkedHashMap<String, String> arrayItemType) {
        if (arrayItemType != null && arrayItemType.containsKey("type")) {
            this.arrayItemType = this.parseItemType(arrayItemType.get("type"));
        }
    }

    private Class parseItemType(String itemTypeString) {
        switch (itemTypeString.toLowerCase()) {
            case "integer": {
                return Integer.class;
            }
            case "number": {
                return Number.class;
            }
            case "string": {
                return String.class;
            }
            case "date": {
                return LocalDateTime.class;
            }
            case "array": {
                return List.class;
            }
        }
        return Object.class;
    }
}

