/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.index.sourcemodels.ish;

import com.sdl.delivery.iq.api.common.EntityFieldType;
import com.sdl.delivery.iq.index.api.client.SourceModel;
import com.sdl.delivery.iq.index.api.data.BaseEntity;
import com.sdl.delivery.iq.index.api.data.EntityField;
import com.sdl.delivery.iq.index.models.BaseBinaryEntity;
import com.sdl.delivery.iq.index.models.BaseIndexEntity;
import com.sdl.delivery.iq.index.models.ContentField;
import com.sdl.delivery.iq.index.models.DefaultBinaryContentField;
import com.sdl.delivery.iq.index.models.IndexField;
import com.sdl.delivery.iq.index.models.deserializers.BaseUpdateByQueryEntity;
import com.sdl.delivery.iq.index.sourcemodels.ish.IndexedIshContent;
import com.sdl.delivery.iq.index.sourcemodels.ish.IshMeta;
import com.sdl.delivery.iq.index.sourcemodels.ish.IshMetadataProperty;
import com.sdl.delivery.iq.index.sourcemodels.ish.IshMetadataPropertyType;
import com.sdl.delivery.iq.index.sourcemodels.ish.IshModelConstants;
import com.sdl.delivery.iq.index.sourcemodels.ish.IshSchemaMeta;
import com.sdl.delivery.iq.index.sourcemodels.ish.ModelUtils;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class IshModel
implements SourceModel<BaseEntity> {
    private Locale locale;
    private IndexedIshContent indexedIshContent;
    private IshMeta ishMeta;
    private IshSchemaMeta ishSchemaMeta;
    private String rawMeta;
    private String rawSchemaMeta;
    private Object rawContent;
    private String key;
    private String modelName;
    private String type;
    private String createdDate;
    private String modifiedDate;
    private String author;
    private Integer publicationId;
    private String publicationTitle;
    private String majorVersion;
    private String minorVersion;
    private String namespace;
    private boolean updateByQuery;

    public IshModel() {
    }

    public IshModel(String rawMeta, String rawSchemaMeta, String rawContent) {
        this.rawMeta = rawMeta;
        this.rawSchemaMeta = rawSchemaMeta;
        this.rawContent = ModelUtils.stripNewlines(ModelUtils.stripControlCharacters(rawContent));
    }

    public IshModel(String rawMeta, String rawSchemaMeta, byte[] rawBinaryContent) {
        this.rawMeta = rawMeta;
        this.rawSchemaMeta = rawSchemaMeta;
        this.rawContent = rawBinaryContent;
    }

    public IshMeta getIshMeta() {
        return this.ishMeta;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Integer getPublicationId() {
        return this.publicationId;
    }

    public void setPublicationId(Integer publicationId) {
        this.publicationId = publicationId;
    }

    public String getPublicationTitle() {
        return this.publicationTitle;
    }

    public void setPublicationTitle(String publicationTitle) {
        this.publicationTitle = publicationTitle;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(String majorVersion) {
        this.majorVersion = majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(String minorVersion) {
        this.minorVersion = minorVersion;
    }

    public IndexedIshContent getIndexedIshContent() {
        return this.indexedIshContent;
    }

    public void setIndexedIshContent(IndexedIshContent indexedIshContent) {
        this.indexedIshContent = indexedIshContent;
    }

    public void setIshMeta(IshMeta ishMeta) {
        this.ishMeta = ishMeta;
    }

    public Optional<IshSchemaMeta> getIshSchemaMeta() {
        return Optional.of(this.ishSchemaMeta);
    }

    public void setIshSchemaMeta(IshSchemaMeta ishSchemaMeta) {
        this.ishSchemaMeta = ishSchemaMeta;
    }

    public String getRawMeta() {
        return this.rawMeta;
    }

    public void setRawMeta(String rawMeta) {
        this.rawMeta = rawMeta;
    }

    public String getRawSchemaMeta() {
        return this.rawSchemaMeta;
    }

    public void setRawSchemaMeta(String rawSchemaMeta) {
        this.rawSchemaMeta = rawSchemaMeta;
    }

    public Object getRawContent() {
        return this.rawContent;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    private Optional<IshMetadataPropertyType> getSchemaMetaForProperty(String propertyName) {
        if (this.ishSchemaMeta != null) {
            return Optional.of(this.ishSchemaMeta.getProperties().get(propertyName));
        }
        return Optional.empty();
    }

    public boolean isUpdateByQuery() {
        return this.updateByQuery;
    }

    public void setUpdateByQuery(boolean updateByQuery) {
        this.updateByQuery = updateByQuery;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public BaseEntity toIndexEntity() {
        switch (this.getIndexedIshContent().getContentType()) {
            case PLAIN: {
                BaseIndexEntity indexEntity = new BaseIndexEntity();
                this.buildBaseEntity(indexEntity);
                this.setContentField(indexEntity);
                this.setRawContentField(indexEntity);
                indexEntity.setCreatedDate(this.getCreatedDate());
                indexEntity.setAuthor(this.getAuthor());
                indexEntity.setPublicationTitle(this.getPublicationTitle());
                return indexEntity;
            }
            case BASE64: {
                BaseBinaryEntity binaryEntity = new BaseBinaryEntity();
                this.buildBaseEntity(binaryEntity);
                this.setBinaryContentField(binaryEntity);
                return binaryEntity;
            }
        }
        throw new IllegalArgumentException("Unhandled type: " + this.type);
    }

    public BaseEntity toIndexEntityForUpdateByQuery() {
        switch (this.getIndexedIshContent().getContentType()) {
            case PLAIN: {
                BaseUpdateByQueryEntity indexEntity = new BaseUpdateByQueryEntity();
                this.buildBaseEntity(indexEntity);
                this.setContentField(indexEntity);
                this.setRawContentField(indexEntity);
                indexEntity.setCreatedDate(this.getCreatedDate());
                indexEntity.setAuthor(this.getAuthor());
                indexEntity.setPublicationTitle(this.getPublicationTitle());
                return indexEntity;
            }
        }
        throw new IllegalArgumentException("Unhandled type: " + this.type);
    }

    public void updateEntityWithPublicationMeta(BaseEntity entity) {
        this.getIshMeta().getProperties().entrySet().stream().filter(entry -> !entity.getField((String)entry.getKey()).isPresent()).forEach(entry -> entity.addField((EntityField)this.createIndexField((String)entry.getKey(), (IshMetadataProperty)entry.getValue())));
    }

    private void buildBaseEntity(BaseEntity entity) {
        entity.setId(this.getKey());
        entity.setLocale(this.getLocale());
        entity.setEntityName("udp-content-default");
        entity.setItemType(this.type);
        entity.setModifiedDate(this.getModifiedDate());
        entity.setMajorVersion(this.getMajorVersion());
        entity.setMinorVersion(this.getMinorVersion());
        entity.setPublicationId(this.getPublicationId());
        entity.setNamespace(this.getNamespace());
        this.getIshMeta().getProperties().forEach((propKey, propValue) -> entity.addField((EntityField)this.createIndexField((String)propKey, (IshMetadataProperty)propValue)));
    }

    private IshModelConstants.LocaleMap findContentLanguage() {
        if (this.locale != null) {
            return IshModelConstants.LocaleMap.findByLanguageCode(this.locale.getLanguage());
        }
        return IshModelConstants.LocaleMap.GENERAL;
    }

    private void setContentField(BaseIndexEntity indexEntity) {
        ContentField contentField = new ContentField(this.findContentLanguage().getFieldSuffix(), this.indexedIshContent == null ? "" : this.indexedIshContent.toString());
        indexEntity.setContent(contentField);
    }

    private void setBinaryContentField(BaseBinaryEntity binaryEntity) {
        DefaultBinaryContentField contentField = new DefaultBinaryContentField(this.findContentLanguage().getFieldSuffix(), this.indexedIshContent == null ? "" : this.indexedIshContent.toString());
        binaryEntity.setContent(contentField);
    }

    private void setRawContentField(BaseIndexEntity indexEntity) {
        Object b = this.getRawContent();
        if (b != null && b instanceof byte[]) {
            indexEntity.setRawContent(new String((byte[])b, Charset.forName("UTF-8")));
        } else if (b != null) {
            indexEntity.setRawContent((String)b);
        }
    }

    private IndexField createIndexField(String propKey, IshMetadataProperty propValue) {
        IndexField indexField = new IndexField(EntityFieldType.INTEGER);
        indexField.setFieldName(propKey);
        indexField.setIsDynamicFieldInIndex(true);
        Optional<IshMetadataPropertyType> schemaMetaProperty = this.getSchemaMetaForProperty(propKey);
        if (schemaMetaProperty.isPresent()) {
            IshMetadataPropertyType ishMetadataPropertyType = schemaMetaProperty.get();
            indexField.setFieldType(IshModel.getFieldType(ishMetadataPropertyType));
            indexField.setIsSearchable(ishMetadataPropertyType.isSearchable());
            if (indexField.getFieldType().equals((Object)EntityFieldType.ARRAY)) {
                indexField.setIsMultiValued(true);
                Class arrayItemType = ishMetadataPropertyType.getArrayItemType();
                indexField.setListItemType(arrayItemType);
            }
        } else {
            indexField.setFieldType(IshModel.getDeserializedType(propValue));
        }
        if (propValue != null) {
            indexField.setValue(propValue.getValue());
        }
        return indexField;
    }

    private static EntityFieldType getDeserializedType(IshMetadataProperty propValue) {
        if (propValue == null || propValue.getType() == null) {
            return EntityFieldType.STRING;
        }
        return IshModel.fromClass((Class)propValue.getType());
    }

    private static EntityFieldType getFieldType(IshMetadataPropertyType propertyType) {
        if (propertyType.getType() == null) {
            return EntityFieldType.STRING;
        }
        return IshModel.fromClass(propertyType.getType());
    }

    private static EntityFieldType fromClass(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return EntityFieldType.STRING;
        }
        if (clazz.equals(Integer.class)) {
            return EntityFieldType.INTEGER;
        }
        if (clazz.equals(Float.class)) {
            return EntityFieldType.FLOAT;
        }
        if (clazz.equals(Double.class)) {
            return EntityFieldType.DOUBLE;
        }
        if (clazz.equals(Date.class)) {
            return EntityFieldType.DATE;
        }
        if (clazz.equals(List.class)) {
            return EntityFieldType.ARRAY;
        }
        return EntityFieldType.STRING;
    }

    public void setCommonFieldValue(Object value, String field) {
        if ("CREATED-ON.lng.value".equals(field)) {
            this.setCreatedDate(value.toString());
        } else if ("MODIFIED-ON.lng.value".equals(field)) {
            this.setModifiedDate(value.toString());
        } else if ("FAUTHOR.lng.value".equals(field)) {
            this.setAuthor(value.toString());
        } else if ("VERSION.version.value".equals(field)) {
            this.setMajorVersion(value.toString());
        } else if ("publicationtitle.generated.value".equals(field)) {
            this.setPublicationTitle(value.toString());
        }
    }
}

