/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.index.sourcemodels.ish;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class IshModelConstants {
    public static final String DEFAULT_ENTITY_NAME = "udp-content-default";
    public static final String ISH_CONTENT_FIELD_NAME = "content";
    public static final String ISH_RAW_CONTENT_FIELD_NAME = "rawcontent";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZZ";
    public static final String CREATED_ON_LNG_VALUE = "CREATED-ON.lng.value";
    public static final String MODIFIED_ON_LNG_VALUE = "MODIFIED-ON.lng.value";
    public static final String FAUTHOR_LNG_VALUE = "FAUTHOR.lng.value";
    public static final String VERSION_VALUE = "VERSION.version.value";
    public static final String PUBLICATIONTITLE_GENERATED_VALUE = "publicationtitle.generated.value";
    public static final List<String> COMMON_FIELDS = Arrays.asList("CREATED-ON.lng.value", "MODIFIED-ON.lng.value", "FAUTHOR.lng.value", "VERSION.version.value", "publicationtitle.generated.value");

    private IshModelConstants() {
    }

    public static enum LocaleMap {
        ARABIC("ar", "arabic"),
        ARMENIAN("hy", "armenian"),
        BASQUE("eu", "basque"),
        BRAZILIAN("pt", "brazilian"),
        BULGARIAN("bg", "bulgarian"),
        CATALAN("ca", "catalan"),
        CHINESE_ZH("zh", "cjk"),
        CHINESE_ZH_CN("zh-cn", "cjk"),
        CHINESE_ZH_TW("zh-tw", "cjk"),
        CHINESE_ZH_HK("zh-hk", "cjk"),
        CHINESE_SIMPLIFIED("zh-Hans", "cjk"),
        CHINESE_TRADITIONAL("zh-Hant", "cjk"),
        CZECH("cs", "czech"),
        DANISH("da", "danish"),
        DUTCH("nl", "dutch"),
        ENGLISH("en", "english"),
        FINNISH("fi", "finnish"),
        FRENCH("fr", "french"),
        GALICIAN("gl", "galician"),
        GERMAN("de", "german"),
        GREEK("el", "greek"),
        HINDI("hi", "hindi"),
        HUNGARIAN("hu", "hungarian"),
        INDONESIAN("id", "indonesian"),
        INDONESIAN_IN("in", "indonesian"),
        IRISH("ga", "irish"),
        ITALIAN("it", "italian"),
        JAPANESE("jp", "cjk"),
        JAPANESE_JA("ja", "cjk"),
        KOREAN("ko", "cjk"),
        LATVIAN("lv", "latvian"),
        LITHUANIAN("lt", "lithuanian"),
        NORWEGIAN_NO("no", "norwegian"),
        NORWEGIAN_BOKMAL("nb", "norwegian"),
        NORWEGIAN_NYNORSK("nn", "norwegian"),
        PERSIAN("fa", "persian"),
        PORTUGUESE("pt", "portuguese"),
        ROMANIAN("ro", "romanian"),
        RUSSIAN("ru", "russian"),
        SORANI("ku", "sorani"),
        SPANISH("es", "spanish"),
        SWEDISH("sv", "swedish"),
        TURKISH("tr", "turkish"),
        THAI("th", "thai"),
        GENERAL("general", "general");

        private String code;
        private String fieldSuffix;

        private LocaleMap(String languageCode, String fieldMapping) {
            this.code = languageCode;
            this.fieldSuffix = fieldMapping;
        }

        public String getCode() {
            return this.code;
        }

        public String getFieldSuffix() {
            return this.fieldSuffix;
        }

        public static LocaleMap findByLanguageCode(String languageCode) {
            for (LocaleMap locale : LocaleMap.values()) {
                if (!Objects.equals(locale.getCode(), languageCode)) continue;
                return locale;
            }
            return GENERAL;
        }

        public static LocaleMap findByFieldSuffix(String fieldSuffix) {
            for (LocaleMap locale : LocaleMap.values()) {
                if (!Objects.equals(locale.getFieldSuffix(), fieldSuffix)) continue;
                return locale;
            }
            return GENERAL;
        }
    }
}

