/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.query.client;

import com.sdl.delivery.configuration.ConfigurationException;
import com.sdl.delivery.iq.client.common.config.ClientConfigurationFactory;
import com.sdl.delivery.iq.query.api.ConfigurationClient;
import com.sdl.delivery.iq.query.api.QueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurer
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurer.class);
    private static ClientConfigurationFactory clientConfigurationFactory = ClientConfigurationFactory.getInstance();
    private final ConfigurationClient configurationClient;

    private DefaultConfigurer(ConfigurationClient client) {
        this.configurationClient = client;
    }

    public static DefaultConfigurer newConfigurer() throws QueryException {
        try {
            String queryClientClass = clientConfigurationFactory.getQueryClientConfiguration().getClientClass();
            Class<?> clientClass = Class.forName(queryClientClass);
            return new DefaultConfigurer((ConfigurationClient)clientClass.newInstance());
        }
        catch (ConfigurationException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new QueryException("Could not instantiate Default Configurer", e);
        }
    }

    public static DefaultConfigurer newConfigurer(ConfigurationClient client) throws QueryException {
        return new DefaultConfigurer(client);
    }

    public void loadLocaleLanguageConfiguration() throws QueryException {
        LOG.debug("Loading Locale language configuration");
        this.configurationClient.loadLocaleLanguageConfiguration();
    }
}

