/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.query.client;

import com.sdl.delivery.configuration.ConfigurationException;
import com.sdl.delivery.iq.client.common.config.ClientConfigurationFactory;
import com.sdl.delivery.iq.query.api.Criteria;
import com.sdl.delivery.iq.query.api.QueryClient;
import com.sdl.delivery.iq.query.api.QueryException;
import com.sdl.delivery.iq.query.api.QueryResult;
import com.sdl.delivery.iq.query.api.QueryResultData;
import com.sdl.delivery.iq.query.api.ResultFilter;
import com.sdl.delivery.iq.query.api.SearcherApi;
import com.sdl.delivery.iq.query.result.SearchResultFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class Searcher<T extends QueryResultData<R>, R extends QueryResult>
implements SearcherApi<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(Searcher.class);
    private static ClientConfigurationFactory clientConfigurationFactory = ClientConfigurationFactory.getInstance();
    private final Class<T> dataResultSetClass;
    private final Class<R> resultClass;
    private final QueryClient queryClient;
    private ResultFilter resultFilter = new SearchResultFilter();
    private String index;

    private Searcher(QueryClient client, Class<T> queryResultDataClass, Class<R> queryResultClass) throws ConfigurationException {
        this.dataResultSetClass = queryResultDataClass;
        this.resultClass = queryResultClass;
        this.queryClient = client;
        this.index = clientConfigurationFactory.getQueryServiceConfiguration().getIndexName();
    }

    public static <T extends QueryResultData<R>, R extends QueryResult> Searcher<T, R> newSearcher(Class<T> queryResultDataClass, Class<R> queryResultClass) throws QueryException {
        Searcher.requireNonNull(queryResultDataClass, "Given result data class is null.");
        Searcher.requireNonNull(queryResultClass, "Given result class is null.");
        try {
            String queryClientClass = clientConfigurationFactory.getQueryClientConfiguration().getClientClass();
            Class<?> clientClass = Class.forName(queryClientClass);
            return new Searcher<T, R>((QueryClient)clientClass.newInstance(), queryResultDataClass, queryResultClass);
        }
        catch (ConfigurationException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new QueryException("Could not instantiate Query Client", e);
        }
    }

    public static <T extends QueryResultData<R>, R extends QueryResult> Searcher<T, R> newSearcher(QueryClient client, Class<T> queryResultDataClass, Class<R> queryResultClass) throws QueryException {
        Searcher.requireNonNull(client, "Given client is null.");
        Searcher.requireNonNull(queryResultDataClass, "Given result data class is null.");
        Searcher.requireNonNull(queryResultClass, "Given result class is null.");
        try {
            return new Searcher<T, R>(client, queryResultDataClass, queryResultClass);
        }
        catch (ConfigurationException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public SearcherApi<T, R> withResultFilter(ResultFilter filter) {
        this.resultFilter = filter;
        return this;
    }

    public SearcherApi<T, R> withIndexName(String indexName) {
        this.index = indexName;
        return this;
    }

    public SearcherApi<T, R> withTransformer(String transformer) {
        this.queryClient.registerQueryTransformer(this.dataResultSetClass, this.resultClass, transformer);
        return this;
    }

    public T search(Criteria criteria) throws QueryException {
        Searcher.requireNonNull(criteria, "No criteria given.");
        return this.performSearch(criteria.getRawQuery());
    }

    public T search(String query) throws QueryException {
        if (StringUtils.isEmpty((Object)query)) {
            throw new QueryException("Raw Query was empty.");
        }
        return this.performSearch(query);
    }

    private T performSearch(String rawQuery) throws QueryException {
        LOG.debug("Performing search. Query is: '{}'", (Object)rawQuery);
        LOG.debug("Index is: '{}'", (Object)this.index);
        LOG.debug("Result Set Class is: '{}'", this.dataResultSetClass);
        return (T)this.queryClient.searchWithCriteria(this.index, rawQuery, this.dataResultSetClass, this.resultClass, this.resultFilter);
    }

    private static void requireNonNull(Object tested, String message) throws QueryException {
        if (tested == null) {
            throw new QueryException(message);
        }
    }
}

