/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.query.compile;

import com.sdl.delivery.common.json.JsonSerializer;
import com.sdl.delivery.common.utils.DateUtils;
import com.sdl.delivery.iq.api.common.EntityFieldType;
import com.sdl.delivery.iq.query.api.BooleanOperationType;
import com.sdl.delivery.iq.query.api.TermValue;
import com.sdl.delivery.iq.query.compile.CompileException;
import com.sdl.delivery.iq.query.compile.QueryCompiler;
import com.sdl.delivery.iq.query.field.DefaultTermValue;
import com.sdl.delivery.iq.query.field.GroupedField;
import com.sdl.delivery.iq.query.field.IdField;
import com.sdl.delivery.iq.query.field.ItemTypeField;
import com.sdl.delivery.iq.query.field.MultiMatchField;
import com.sdl.delivery.iq.query.field.RangeField;
import com.sdl.delivery.iq.query.field.SingleField;
import com.sdl.delivery.iq.query.search.SearchNode;
import com.sdl.delivery.iq.query.search.SearchQuery;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultQueryCompiler
implements QueryCompiler {
    @Override
    public String compile(SearchNode node) throws CompileException {
        return this.compileOptional(node).orElseThrow(() -> new CompileException("Not a valid query!"));
    }

    String serializeQuery(SearchQuery query) throws CompileException {
        String queryNodes;
        BooleanOperationType type = query.getBooleanOperation().orElseThrow(() -> new CompileException("Operation is not specified"));
        SearchNode left = query.left();
        switch (left.getType()) {
            case NIL: {
                throw new CompileException("Query is empty!");
            }
            case ID: 
            case GROUPED: {
                queryNodes = JsonSerializer.writeField((String)"nodes", (String)this.compileOptional(query.left()).orElseThrow(() -> new CompileException("Missing node!")), JsonSerializer::wrapInBrackets);
                break;
            }
            default: {
                queryNodes = JsonSerializer.writeField((String)"nodes", (String)((String)Stream.of(this.compileOptional(query.left()), this.compileOptional(query.right())).filter(Optional::isPresent).map(Optional::get).collect(JsonSerializer.concat())), JsonSerializer::wrapInBrackets);
            }
        }
        return JsonSerializer.wrapInBraces((String)((String)Stream.of(Optional.of(JsonSerializer.writeSimpleValue((String)"type", (String)"query")), Optional.of(JsonSerializer.writeSimpleValue((String)"op", (String)type.toString())), Optional.ofNullable(this.serializeNestedSection(query.isNested(), query.getNestedPath())), query.getSortFields().map(sortList -> this.serializeSortSection((List<String>)sortList, query.isSortStrings())), Optional.ofNullable(query.isSortDescending() ? JsonSerializer.writeSimpleValue((String)"descending", (String)"true") : null), Optional.of(queryNodes)).filter(Optional::isPresent).map(Optional::get).collect(JsonSerializer.concat())));
    }

    String serializeNestedSection(boolean nested, String path) {
        return nested ? JsonSerializer.writeSimpleValue((String)"nested", (String)path) : null;
    }

    String serializeSortSection(List<String> sortList, boolean sortStrings) {
        List<String> adjustedSortList = sortStrings ? sortList.stream().map(field -> field + ".keyword").collect(Collectors.toList()) : sortList;
        return JsonSerializer.writeListValue((String)"sort", adjustedSortList);
    }

    String serializeValue(Object value, EntityFieldType type) {
        switch (type) {
            case DATE: {
                return DateUtils.getFormattedDate((String)DateUtils.DEFAULT_DATE_TIME_FORMAT.format((OffsetDateTime)value));
            }
        }
        return value.toString().replaceAll("\"", "\\\\\"").replaceAll("\\p{Cc}", "");
    }

    String serializeTermBoost(SingleField singleField) {
        if (singleField.isTerm()) {
            double boost = ((DefaultTermValue)singleField.getTermValue()).getBoost();
            return boost != 0.0 ? JsonSerializer.writeSimpleValue((String)"boost", (String)String.valueOf(boost)) : null;
        }
        return null;
    }

    String serializeTermType(SingleField singleField) {
        return singleField.isTerm() ? JsonSerializer.writeSimpleValue((String)"termType", (String)((DefaultTermValue)singleField.getTermValue()).getType().toString()) : null;
    }

    String serializeSingleSearchField(SingleField singleField) {
        Object value = singleField.getValue();
        EntityFieldType fieldType = singleField.getFieldType();
        return (String)Arrays.asList(Optional.of(JsonSerializer.writeSimpleValue((String)"type", (String)"field")), Optional.ofNullable(singleField.isNegate() ? JsonSerializer.writeSimpleValue((String)"negate", (String)"true") : null), Optional.of(JsonSerializer.writeSimpleValue((String)"key", (String)singleField.getName())), Optional.of(JsonSerializer.writeSimpleValue((String)"value", (String)this.serializeValue(singleField.isTerm() ? singleField.getTermValue().getValue() : value, fieldType))), Optional.ofNullable(this.serializeTermType(singleField)), Optional.ofNullable(this.serializeTermBoost(singleField)), Optional.of(JsonSerializer.writeSimpleValue((String)"fieldType", (String)fieldType.toString()))).stream().filter(Optional::isPresent).map(Optional::get).collect(JsonSerializer.concat());
    }

    String serializeRangeSearchField(RangeField rangeField) {
        EntityFieldType fieldType = rangeField.getFieldType();
        return (String)Arrays.asList(Optional.of(JsonSerializer.writeSimpleValue((String)"type", (String)"range")), Optional.ofNullable(rangeField.isNegate() ? JsonSerializer.writeSimpleValue((String)"negate", (String)"true") : null), Optional.of(JsonSerializer.writeSimpleValue((String)"key", (String)rangeField.getName())), Optional.ofNullable(rangeField.getLeft()).map(leftVal -> JsonSerializer.writeSimpleValue((String)"left", (String)this.serializeValue(leftVal, fieldType))), Optional.ofNullable(rangeField.getRight()).map(rightVal -> JsonSerializer.writeSimpleValue((String)"right", (String)this.serializeValue(rightVal, fieldType))), Optional.of(JsonSerializer.writeSimpleValue((String)"leftClosed", (String)Boolean.toString(rangeField.isLeftClosed()))), Optional.of(JsonSerializer.writeSimpleValue((String)"rightClosed", (String)Boolean.toString(rangeField.isRightClosed()))), Optional.of(JsonSerializer.writeSimpleValue((String)"fieldType", (String)fieldType.toString()))).stream().filter(Optional::isPresent).map(Optional::get).collect(JsonSerializer.concat());
    }

    String serializeMultiSearchField(GroupedField multiField) {
        Function<Object, Map.Entry> zipper;
        List<Object> fieldTypes;
        Optional fieldTypesOpt = multiField.getFieldTypes().stream().collect(Collectors.reducing((type1, type2) -> type1 == type2 ? type1 : null));
        List<Object> list = fieldTypes = fieldTypesOpt.isPresent() ? Collections.singletonList(fieldTypesOpt.get()) : multiField.getFieldTypes();
        if (fieldTypes.size() > 1) {
            Iterator<Object> typeIterator = fieldTypes.iterator();
            zipper = val -> new AbstractMap.SimpleEntry(val, typeIterator.next());
        } else {
            zipper = val -> new AbstractMap.SimpleEntry(val, fieldTypes.get(0));
        }
        List valEntries = multiField.isTerm() ? multiField.getTermValues().stream().map(zipper).collect(Collectors.toList()) : multiField.getValues().stream().map(zipper).collect(Collectors.toList());
        return (String)Arrays.asList(Optional.of(JsonSerializer.writeSimpleValue((String)"type", (String)"group")), Optional.ofNullable(multiField.isNegate() ? JsonSerializer.writeSimpleValue((String)"negate", (String)"true") : null), Optional.of(JsonSerializer.writeListValue((String)"keys", multiField.getNames())), Optional.of(JsonSerializer.writeListValue((String)"values", (Collection)(multiField.isTerm() ? (Collection)valEntries.stream().map(entry -> this.serializeValue(((TermValue)entry.getKey()).getValue(), (EntityFieldType)entry.getValue())).collect(Collectors.toList()) : (Collection)valEntries.stream().map(entry -> this.serializeValue(entry.getKey(), (EntityFieldType)entry.getValue())).collect(Collectors.toList())))), Optional.ofNullable(multiField.isTerm() ? JsonSerializer.writeListValue((String)"termTypes", (Collection)valEntries.stream().map(entry -> ((DefaultTermValue)entry.getKey()).getType().toString()).collect(Collectors.toList())) : null), Optional.ofNullable(multiField.isTerm() ? JsonSerializer.writeListValue((String)"boostValues", (Collection)valEntries.stream().map(entry -> String.valueOf(((DefaultTermValue)entry.getKey()).getBoost())).collect(Collectors.toList())) : null), Optional.of(JsonSerializer.writeListValue((String)"types", (Collection)fieldTypes.stream().map(Enum::toString).collect(Collectors.toList())))).stream().filter(Optional::isPresent).map(Optional::get).collect(JsonSerializer.concat());
    }

    String serializeIdField(IdField idField) {
        return JsonSerializer.wrapInBraces((String)((String)Arrays.asList(Optional.of(JsonSerializer.writeSimpleValue((String)"type", (String)"id")), Optional.ofNullable(idField.isNegate() ? JsonSerializer.writeSimpleValue((String)"negate", (String)"true") : null), Optional.of(JsonSerializer.writeSimpleValue((String)"key", (String)idField.getId()))).stream().filter(Optional::isPresent).map(Optional::get).collect(JsonSerializer.concat())));
    }

    String serializeMultiMatchField(MultiMatchField mmField) {
        return JsonSerializer.wrapInBraces((String)((String)Arrays.asList(Optional.of(JsonSerializer.writeSimpleValue((String)"type", (String)"multiMatch")), Optional.ofNullable(mmField.isNegate() ? JsonSerializer.writeSimpleValue((String)"negate", (String)"true") : null), Optional.of(JsonSerializer.writeSimpleValue((String)"query", (String)mmField.getQuery())), Optional.of(JsonSerializer.writeListValue((String)"fieldlist", mmField.getFields())), Optional.of(JsonSerializer.writeSimpleValue((String)"matchOp", (String)mmField.getOperation().toString())), Optional.of(JsonSerializer.writeSimpleValue((String)"matchType", (String)mmField.getType().toString()))).stream().filter(Optional::isPresent).map(Optional::get).collect(JsonSerializer.concat())));
    }

    String serializeItemTypeField(ItemTypeField itemTypeField) {
        return JsonSerializer.wrapInBraces((String)((String)Arrays.asList(Optional.of(JsonSerializer.writeSimpleValue((String)"type", (String)"itemType")), Optional.ofNullable(itemTypeField.isNegate() ? JsonSerializer.writeSimpleValue((String)"negate", (String)"true") : null), Optional.of(JsonSerializer.writeSimpleValue((String)"key", (String)itemTypeField.getItemType()))).stream().filter(Optional::isPresent).map(Optional::get).collect(JsonSerializer.concat())));
    }

    String serializeField(SingleField field) throws CompileException {
        return JsonSerializer.wrapInBraces((String)this.serializeSingleSearchField(field));
    }

    String serializeRange(RangeField field) throws CompileException {
        return JsonSerializer.wrapInBraces((String)this.serializeRangeSearchField(field));
    }

    String serializeGrouped(GroupedField field) throws CompileException {
        return JsonSerializer.wrapInBraces((String)this.serializeMultiSearchField(field));
    }

    Optional<String> compileOptional(SearchNode node) throws CompileException {
        switch (node.getType()) {
            case NIL: {
                return Optional.empty();
            }
            case ID: {
                return Optional.of(this.serializeIdField(node.getId()));
            }
            case MULTI_MATCH: {
                return Optional.of(this.serializeMultiMatchField(node.getMultiMatch()));
            }
            case ITEM_TYPE: {
                return Optional.of(this.serializeItemTypeField(node.getItemType()));
            }
            case FIELD: {
                return Optional.of(this.serializeField(node.getField()));
            }
            case RANGE: {
                return Optional.of(this.serializeRange(node.getRange()));
            }
            case GROUPED: {
                return Optional.of(this.serializeGrouped(node.getGrouped()));
            }
            case QUERY: {
                return Optional.of(this.serializeQuery((SearchQuery)node.getQuery()));
            }
        }
        throw new CompileException("Unhandled node type!");
    }
}

