/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.query.field;

import com.sdl.delivery.iq.api.common.EntityFieldType;
import com.sdl.delivery.iq.query.api.TermValue;
import com.sdl.delivery.iq.query.field.BaseField;
import com.sdl.delivery.iq.query.field.FieldException;
import com.sdl.delivery.iq.query.field.FieldUtils;
import java.util.List;
import java.util.stream.Collectors;

public class GroupedField
extends BaseField {
    private List<String> names;
    private List<Object> values;
    private List<TermValue> termValues;
    private List<EntityFieldType> fieldTypes;
    private boolean term;

    public GroupedField(boolean negate) {
        super(negate);
    }

    public <T> GroupedField(boolean negate, List<String> names, List values, Class<T> clazz) throws FieldException {
        this(negate);
        if (values.size() != 1 && values.size() != names.size()) {
            throw new FieldException("Invalid usage of multi value search. Size of values should be one or equal to size of names.");
        }
        this.names = names;
        if (Object.class.equals(clazz)) {
            this.term = false;
            this.values = values;
            this.fieldTypes = values.stream().map(FieldUtils::detectType).collect(Collectors.toList());
        } else {
            this.term = true;
            this.termValues = values;
            this.fieldTypes = values.stream().map(TermValue::getValue).map(FieldUtils::detectType).collect(Collectors.toList());
        }
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public List<EntityFieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public void setFieldTypes(List<EntityFieldType> fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public List<TermValue> getTermValues() {
        return this.termValues;
    }

    public boolean isTerm() {
        return this.term;
    }
}

