/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.query.operation;

import com.sdl.delivery.iq.query.api.BooleanOperation;
import com.sdl.delivery.iq.query.api.BooleanOperationType;
import com.sdl.delivery.iq.query.api.Criteria;
import com.sdl.delivery.iq.query.api.Query;
import com.sdl.delivery.iq.query.api.QueryException;
import com.sdl.delivery.iq.query.compile.CompileException;
import com.sdl.delivery.iq.query.compile.DefaultQueryCompiler;
import com.sdl.delivery.iq.query.compile.QueryCompiler;
import com.sdl.delivery.iq.query.operation.AndOperation;
import com.sdl.delivery.iq.query.operation.OrOperation;
import com.sdl.delivery.iq.query.operation.UnitOperation;
import com.sdl.delivery.iq.query.search.SearchCriteria;
import com.sdl.delivery.iq.query.search.SearchNode;
import java.util.List;

public abstract class BaseOperation
implements BooleanOperation {
    private final Query query;
    private final BooleanOperationType type;
    private final QueryCompiler compiler;

    public BaseOperation(Query query, BooleanOperationType type) {
        this.query = query;
        this.type = type;
        this.compiler = new DefaultQueryCompiler();
    }

    public BooleanOperationType getType() {
        return this.type;
    }

    public Query and() {
        return this.query.withOperation((BooleanOperation)new AndOperation(this.query));
    }

    public Query or() {
        return this.query.withOperation((BooleanOperation)new OrOperation(this.query));
    }

    public BooleanOperation groupEnd() throws QueryException {
        return new UnitOperation(this.query.groupEnd());
    }

    public Criteria compile() throws QueryException {
        try {
            return new SearchCriteria(this.compiler.compile(SearchNode.querySearchNode(this.query)));
        }
        catch (CompileException e) {
            throw new QueryException("Compilation failed", (Throwable)e);
        }
    }

    public BooleanOperation sortByAscending(List<String> fieldNames) {
        this.query.sortFieldsAscending(fieldNames);
        return this;
    }

    public BooleanOperation sortByDescending(List<String> fieldNames) {
        this.query.sortFieldsDescending(fieldNames);
        return this;
    }

    public BooleanOperation sortStringByAscending(List<String> fieldNames) {
        this.query.sortStringFieldsAscending(fieldNames);
        return this;
    }

    public BooleanOperation sortStringByDescending(List<String> fieldNames) {
        this.query.sortStringFieldsDescending(fieldNames);
        return this;
    }
}

