/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.query.result;

import com.sdl.delivery.iq.query.api.ResultFilter;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class SearchResultFilter
implements ResultFilter {
    private Set<String> excludeFields;
    private Integer startRange;
    private Integer endRange;
    private Integer resultLimit;
    private boolean enableHighlighting = false;
    private boolean enableHighlightInAll = false;

    public static ResultFilter create() {
        return new SearchResultFilter();
    }

    public ResultFilter excludeFields(Set<String> fields) {
        if (fields != null) {
            this.excludeFields = fields;
        }
        return this;
    }

    public ResultFilter withResultSetRange(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("End of range can not be smaller than start of range.");
        }
        this.startRange = start;
        this.endRange = end;
        return this;
    }

    public ResultFilter maxResults(int maxResults) {
        this.resultLimit = maxResults;
        return this;
    }

    public ResultFilter enableHighlighting() {
        this.enableHighlighting = true;
        return this;
    }

    public ResultFilter enableHighlightInAll() {
        this.enableHighlightInAll = true;
        return this;
    }

    public Optional<Set<String>> getExcludeFields() {
        return Optional.ofNullable(this.excludeFields);
    }

    public OptionalInt getStartOfRange() {
        return this.startRange != null ? OptionalInt.of(this.startRange) : OptionalInt.empty();
    }

    public OptionalInt getEndOfRange() {
        return this.endRange != null ? OptionalInt.of(this.endRange) : OptionalInt.empty();
    }

    public OptionalInt getMaxResults() {
        return this.resultLimit != null ? OptionalInt.of(this.resultLimit) : OptionalInt.empty();
    }

    public boolean highLightingIsEnabled() {
        return this.enableHighlighting;
    }

    public boolean highLightInAllIsEnabled() {
        return this.enableHighlightInAll;
    }
}

