/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.query.search;

import com.sdl.delivery.iq.query.api.Query;
import com.sdl.delivery.iq.query.field.GroupedField;
import com.sdl.delivery.iq.query.field.IdField;
import com.sdl.delivery.iq.query.field.ItemTypeField;
import com.sdl.delivery.iq.query.field.MultiMatchField;
import com.sdl.delivery.iq.query.field.RangeField;
import com.sdl.delivery.iq.query.field.SingleField;

public class SearchNode {
    private IdField id;
    private ItemTypeField itemType;
    private SingleField field;
    private RangeField range;
    private GroupedField grouped;
    private Query query;
    private SearchNodeType type;
    private MultiMatchField multiMatch;

    private SearchNode() {
        this.type = SearchNodeType.NIL;
    }

    private SearchNode(IdField id) {
        this.id = id;
        this.type = SearchNodeType.ID;
    }

    private SearchNode(ItemTypeField itemType) {
        this.itemType = itemType;
        this.type = SearchNodeType.ITEM_TYPE;
    }

    private SearchNode(SingleField field) {
        this.field = field;
        this.type = SearchNodeType.FIELD;
    }

    private SearchNode(RangeField range) {
        this.range = range;
        this.type = SearchNodeType.RANGE;
    }

    private SearchNode(GroupedField grouped) {
        this.grouped = grouped;
        this.type = SearchNodeType.GROUPED;
    }

    private SearchNode(Query query) {
        this.query = query;
        this.type = SearchNodeType.QUERY;
    }

    private SearchNode(MultiMatchField mmField) {
        this.multiMatch = mmField;
        this.type = SearchNodeType.MULTI_MATCH;
    }

    public static SearchNode fieldSearchNode(SingleField singleField) {
        return new SearchNode(singleField);
    }

    public static SearchNode querySearchNode(Query query) {
        return new SearchNode(query);
    }

    public static SearchNode rangeSearchNode(RangeField rangeField) {
        return new SearchNode(rangeField);
    }

    public static SearchNode groupedSearchNode(GroupedField groupedField) {
        return new SearchNode(groupedField);
    }

    public static SearchNode idSearchNode(IdField idField) {
        return new SearchNode(idField);
    }

    public static SearchNode multiMatchSearchNode(MultiMatchField mmField) {
        return new SearchNode(mmField);
    }

    public static SearchNode itemTypeSearchNode(ItemTypeField itemTypeField) {
        return new SearchNode(itemTypeField);
    }

    public static SearchNode nilSearchNode() {
        return new SearchNode();
    }

    public boolean isNil() {
        return this.type == SearchNodeType.NIL;
    }

    public SearchNodeType getType() {
        return this.type;
    }

    public SingleField getField() {
        return this.field;
    }

    public Query getQuery() {
        return this.query;
    }

    public IdField getId() {
        return this.id;
    }

    public ItemTypeField getItemType() {
        return this.itemType;
    }

    public RangeField getRange() {
        return this.range;
    }

    public GroupedField getGrouped() {
        return this.grouped;
    }

    public MultiMatchField getMultiMatch() {
        return this.multiMatch;
    }

    public static enum SearchNodeType {
        NIL,
        ID,
        MULTI_MATCH,
        ITEM_TYPE,
        FIELD,
        RANGE,
        GROUPED,
        QUERY;

    }
}

