/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.iq.query.search;

import com.sdl.delivery.iq.api.common.EntityFieldType;
import com.sdl.delivery.iq.query.api.BooleanOperation;
import com.sdl.delivery.iq.query.api.BooleanOperationType;
import com.sdl.delivery.iq.query.api.MatchOperation;
import com.sdl.delivery.iq.query.api.MatchType;
import com.sdl.delivery.iq.query.api.Query;
import com.sdl.delivery.iq.query.api.QueryException;
import com.sdl.delivery.iq.query.api.TermValue;
import com.sdl.delivery.iq.query.field.GroupedField;
import com.sdl.delivery.iq.query.field.IdField;
import com.sdl.delivery.iq.query.field.ItemTypeField;
import com.sdl.delivery.iq.query.field.MultiMatchField;
import com.sdl.delivery.iq.query.field.RangeField;
import com.sdl.delivery.iq.query.field.SingleField;
import com.sdl.delivery.iq.query.operation.AndOperation;
import com.sdl.delivery.iq.query.operation.BaseOperation;
import com.sdl.delivery.iq.query.operation.OrOperation;
import com.sdl.delivery.iq.query.operation.UnitOperation;
import com.sdl.delivery.iq.query.search.SearchNode;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SearchQuery
implements Query {
    private BaseOperation operation;
    private SearchNode left = SearchNode.nilSearchNode();
    private SearchNode right = SearchNode.nilSearchNode();
    private Query parent;
    private boolean negateNext = false;
    private List<String> sortFields;
    private boolean sortDescending = false;
    private boolean sortStrings = false;
    private boolean nested;
    private String nestedPath;

    private SearchQuery() {
    }

    public static Query newQuery() {
        return new SearchQuery();
    }

    public static Query newNestedQuery(String nestedPath) {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.nestedPath = nestedPath;
        searchQuery.nested = true;
        return searchQuery;
    }

    private SearchQuery(SearchQuery parent) {
        Objects.requireNonNull(parent);
        this.parent = parent;
    }

    public Query groupStart() throws QueryException {
        SearchNode child = SearchNode.querySearchNode(new SearchQuery(this));
        this.setFieldInOrder(child);
        return child.getQuery();
    }

    public Query not() {
        this.negateNext = true;
        return this;
    }

    public Optional<BooleanOperationType> getBooleanOperation() {
        return Optional.ofNullable(this.operation).map(BaseOperation::getType);
    }

    public BooleanOperation id(String idString) throws QueryException {
        return this.applyUnaryNode(SearchNode.idSearchNode(new IdField(this.negateNext, idString)), new UnitOperation(this));
    }

    public BooleanOperation id(String sourceIdentifier, int publicationId, int itemId, int itemType) throws QueryException {
        return this.id(String.format("%s:%d-%d-%d", sourceIdentifier, publicationId, itemId, itemType));
    }

    public BooleanOperation multiMatch(String query) throws QueryException {
        return this.applyBinaryNode(SearchNode.multiMatchSearchNode(new MultiMatchField(this.negateNext, query)));
    }

    public BooleanOperation multiMatch(List<String> wildCardFieldNames, String query) throws QueryException {
        return this.applyBinaryNode(SearchNode.multiMatchSearchNode(new MultiMatchField(this.negateNext, query, wildCardFieldNames)));
    }

    public BooleanOperation multiMatch(List<String> wildCardFieldNames, String query, MatchOperation matchOperation) throws QueryException {
        return this.applyBinaryNode(SearchNode.multiMatchSearchNode(new MultiMatchField(this.negateNext, query, wildCardFieldNames, matchOperation)));
    }

    public BooleanOperation multiMatch(List<String> wildCardFieldNames, String query, MatchOperation matchOperation, MatchType type) throws QueryException {
        return this.applyBinaryNode(SearchNode.multiMatchSearchNode(new MultiMatchField(this.negateNext, query, wildCardFieldNames, matchOperation, type)));
    }

    public BooleanOperation itemType(String itemType) throws QueryException {
        return this.applyBinaryNode(SearchNode.itemTypeSearchNode(new ItemTypeField(this.negateNext, itemType)));
    }

    public BooleanOperation field(String fieldName, String fieldValue) throws QueryException {
        return this.applyBinaryNode(SearchNode.fieldSearchNode(new SingleField(this.negateNext, fieldName, fieldValue)));
    }

    public BooleanOperation field(String fieldName, TermValue fieldValue) throws QueryException {
        return this.applyBinaryNode(SearchNode.fieldSearchNode(new SingleField(this.negateNext, fieldName, fieldValue)));
    }

    public BooleanOperation field(String fieldName, Object fieldValue) throws QueryException {
        return this.applyBinaryNode(SearchNode.fieldSearchNode(new SingleField(this.negateNext, fieldName, fieldValue)));
    }

    public BooleanOperation range(String fieldName, OffsetDateTime lower, OffsetDateTime upper) throws QueryException {
        RangeField field = new RangeField(this.negateNext, fieldName, EntityFieldType.DATE, lower, upper);
        return this.applyBinaryNode(SearchNode.rangeSearchNode(field));
    }

    public BooleanOperation range(String fieldName, OffsetDateTime lower, OffsetDateTime upper, boolean includeLower, boolean includeUpper) throws QueryException {
        RangeField field = new RangeField(this.negateNext, fieldName, EntityFieldType.DATE, lower, includeLower, upper, includeUpper);
        return this.applyBinaryNode(SearchNode.rangeSearchNode(field));
    }

    public BooleanOperation range(String fieldName, Integer lower, Integer upper) throws QueryException {
        RangeField field = new RangeField(this.negateNext, fieldName, EntityFieldType.INTEGER, lower, upper);
        return this.applyBinaryNode(SearchNode.rangeSearchNode(field));
    }

    public BooleanOperation range(String fieldName, Integer lower, Integer upper, boolean includeLower, boolean includeUpper) throws QueryException {
        RangeField field = new RangeField(this.negateNext, fieldName, EntityFieldType.INTEGER, lower, includeLower, upper, includeUpper);
        return this.applyBinaryNode(SearchNode.rangeSearchNode(field));
    }

    public BooleanOperation range(String fieldName, Double lower, Double upper) throws QueryException {
        return this.applyBinaryNode(SearchNode.rangeSearchNode(new RangeField(this.negateNext, fieldName, EntityFieldType.DOUBLE, lower, upper)));
    }

    public BooleanOperation range(String fieldName, Double lower, Double upper, boolean includeLower, boolean includeUpper) throws QueryException {
        RangeField field = new RangeField(this.negateNext, fieldName, EntityFieldType.DOUBLE, lower, includeLower, upper, includeUpper);
        return this.applyBinaryNode(SearchNode.rangeSearchNode(field));
    }

    public BooleanOperation range(String fieldName, Float lower, Float upper) throws QueryException {
        return this.applyBinaryNode(SearchNode.rangeSearchNode(new RangeField(this.negateNext, fieldName, EntityFieldType.FLOAT, lower, upper)));
    }

    public BooleanOperation range(String fieldName, Float lower, Float upper, boolean includeLower, boolean includeUpper) throws QueryException {
        RangeField field = new RangeField(this.negateNext, fieldName, EntityFieldType.FLOAT, lower, includeLower, upper, includeUpper);
        return this.applyBinaryNode(SearchNode.rangeSearchNode(field));
    }

    public BooleanOperation range(String fieldName, Long lower, Long upper) throws QueryException {
        return this.applyBinaryNode(SearchNode.rangeSearchNode(new RangeField(this.negateNext, fieldName, EntityFieldType.LONG, lower, upper)));
    }

    public BooleanOperation range(String fieldName, Long lower, Long upper, boolean includeLower, boolean includeUpper) throws QueryException {
        RangeField field = new RangeField(this.negateNext, fieldName, EntityFieldType.LONG, lower, includeLower, upper, includeUpper);
        return this.applyBinaryNode(SearchNode.rangeSearchNode(field));
    }

    public BooleanOperation range(String fieldName, String lower, String upper) throws QueryException {
        return this.applyBinaryNode(SearchNode.rangeSearchNode(new RangeField(this.negateNext, fieldName, EntityFieldType.STRING, lower, upper)));
    }

    public BooleanOperation range(String fieldName, String lower, String upper, boolean includeLower, boolean includeUpper) throws QueryException {
        RangeField field = new RangeField(this.negateNext, fieldName, EntityFieldType.STRING, lower, includeLower, upper, includeUpper);
        return this.applyBinaryNode(SearchNode.rangeSearchNode(field));
    }

    public BooleanOperation groupedAnd(List<String> fields, List<?> query) throws QueryException {
        return this.groupedOperation(fields, query, new AndOperation(this), this.negateNext);
    }

    public BooleanOperation groupedOr(List<String> fields, List<?> query) throws QueryException {
        return this.groupedOperation(fields, query, new OrOperation(this), this.negateNext);
    }

    public BooleanOperation groupedNot(List<String> fields, List<?> query) throws QueryException {
        return this.groupedOperation(fields, query, new AndOperation(this), true);
    }

    public Query groupEnd() throws QueryException {
        if (this.parent == null) {
            throw new QueryException("Not in a group!");
        }
        return this.parent;
    }

    public Query sortFieldsAscending(List<String> fieldNames) {
        this.sortFields = fieldNames;
        this.sortDescending = false;
        return this;
    }

    public Query sortFieldsDescending(List<String> fieldNames) {
        this.sortFields = fieldNames;
        this.sortDescending = true;
        return this;
    }

    public Query sortStringFieldsAscending(List<String> fieldNames) {
        this.sortStrings = true;
        return this.sortFieldsAscending(fieldNames);
    }

    public Query sortStringFieldsDescending(List<String> fieldNames) {
        this.sortStrings = true;
        return this.sortFieldsDescending(fieldNames);
    }

    public Query withOperation(BooleanOperation op) {
        this.operation = (BaseOperation)op;
        return this;
    }

    public boolean isNested() {
        return this.nested;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public Optional<List<String>> getSortFields() {
        return Optional.ofNullable(this.sortFields);
    }

    public boolean isSortStrings() {
        return this.sortStrings;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public SearchNode left() {
        return this.left;
    }

    public SearchNode right() {
        return this.right;
    }

    BooleanOperation groupedOperation(List<String> fields, List<?> query, BaseOperation baseOp, boolean negate) throws QueryException {
        this.checkCollectionSize(fields);
        this.checkCollectionSize(query);
        Class<?> headClass = query.get(0).getClass();
        Class<TermValue> termValueClass = TermValue.class;
        if (termValueClass.isAssignableFrom(headClass)) {
            if (query.stream().anyMatch(o -> !termValueClass.isAssignableFrom(o.getClass()))) {
                throw new QueryException("All elements must be either TermValue instances or not");
            }
            return this.applyUnaryNode(SearchNode.groupedSearchNode(new GroupedField(negate, fields, query, TermValue.class)), baseOp);
        }
        if (query.stream().anyMatch(o -> termValueClass.isAssignableFrom(o.getClass()))) {
            throw new QueryException("All elements must be either TermValue instances or not");
        }
        return this.applyUnaryNode(SearchNode.groupedSearchNode(new GroupedField(negate, fields, query, Object.class)), baseOp);
    }

    void checkCollectionSize(Collection<?> collection) throws QueryException {
        if (null == collection || collection.size() == 0) {
            throw new QueryException("Collection is empty");
        }
    }

    BooleanOperation applyBinaryNode(SearchNode node) throws QueryException {
        this.setFieldInOrder(node);
        this.negateNext = false;
        if (this.operation == null) {
            this.operation = new UnitOperation(this);
        }
        return this.operation;
    }

    BaseOperation applyUnaryNode(SearchNode node, BaseOperation op) throws QueryException {
        if (!this.left.isNil()) {
            throw new QueryException("Can not use this field inside binary operation");
        }
        this.left = node;
        this.operation = op;
        this.negateNext = false;
        return this.operation;
    }

    void setFieldInOrder(SearchNode field) throws QueryException {
        if (this.left.isNil()) {
            this.left = field;
        } else if (this.right.isNil()) {
            this.right = field;
        } else {
            throw new QueryException("All fields are set!");
        }
    }
}

