/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.oauth.common;

import com.sdl.web.oauth.common.OAuthException;
import com.sdl.web.oauth.common.OAuthToken;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuthToken
implements OAuthToken {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOAuthToken.class);
    private static final Pattern PARAMETERS_SPLITTER = Pattern.compile("&");
    private static final Pattern ATTR_SPLITTER = Pattern.compile("(?<attr>.+?)=(?<value>.+)");
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String SEPARATOR = "&";
    private static final String DIGEST = "digest";
    private static final long NANO_TO_MILLIS = 1000000L;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final String refreshToken;

    public DefaultOAuthToken(SecretKey key, Map<String, String> authAttributes, String tokenToRefresh) throws OAuthException {
        String attrs = authAttributes.entrySet().stream().map(x -> (String)x.getKey() + KEY_VALUE_SEPARATOR + (String)x.getValue()).collect(Collectors.joining(SEPARATOR));
        this.attributes.putAll(authAttributes);
        this.attributes.put(DIGEST, DefaultOAuthToken.doCalculateDigest(key, attrs));
        this.refreshToken = tokenToRefresh == null ? "" : tokenToRefresh;
    }

    public DefaultOAuthToken(String token, String refreshToken) throws OAuthException {
        this(null, token, refreshToken);
    }

    public DefaultOAuthToken(SecretKey key, String token, String refreshToken) throws OAuthException {
        String expectedDigest;
        String digest = null;
        StringBuilder data = new StringBuilder();
        for (String parameter : PARAMETERS_SPLITTER.split(token)) {
            Matcher matcher = ATTR_SPLITTER.matcher(parameter);
            if (!matcher.find()) continue;
            String attr = matcher.group("attr");
            String value = matcher.group("value");
            if (value == null || value.isEmpty()) continue;
            if (attr.equals(DIGEST)) {
                digest = value;
                this.attributes.put(DIGEST, digest);
                continue;
            }
            if (data.length() > 0) {
                data.append(SEPARATOR);
            }
            data.append(parameter);
            this.attributes.put(attr, value);
        }
        if (digest == null) {
            LOG.error("Digest is missing in token '{}'.", (Object)token);
            throw new OAuthException("Digest is wrong (missing in token) " + token);
        }
        if (key == null) {
            LOG.debug("Token validation is skipping for " + token);
        }
        String string = expectedDigest = key != null ? DefaultOAuthToken.doCalculateDigest(key, data.toString()) : null;
        if (key != null && !digest.equals(expectedDigest)) {
            LOG.error("Digest '{}' is wrong, expected '{}' for '{}'.", new Object[]{expectedDigest, digest, data.toString()});
            throw new OAuthException("Digest is wrong, " + expectedDigest + "=!=" + digest + " in token " + token);
        }
        if (this.attributes.containsKey("expiresOn")) {
            long expiresOn = Long.parseLong(this.attributes.get("expiresOn"));
            long expired = Instant.now().toEpochMilli() - expiresOn;
            if (expired > 0L) {
                LOG.info("Token expired {} ms ago.", (Object)expired);
                throw new OAuthException("Token expired.");
            }
        } else {
            LOG.error("Missing expiresOn parameter in '{}'.", (Object)data.toString());
            throw new OAuthException("Missing expiresOn parameter.");
        }
        this.refreshToken = refreshToken == null ? "" : refreshToken;
    }

    public static String doCalculateDigest(SecretKey secretKey, String data) throws OAuthException {
        try {
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8.name());
            Mac mc = Mac.getInstance(secretKey.getAlgorithm());
            mc.init(secretKey);
            mc.update(bytes, 0, bytes.length);
            byte[] digest = mc.doFinal();
            return new String(Base64.getUrlEncoder().encode(digest));
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            throw new OAuthException("Unable to calculate digest for '" + data + "'", e);
        }
    }

    @Override
    public String getClientId() {
        return this.attributes.get("client_id");
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public long getExpiresOn() {
        return Long.valueOf(this.attributes.get("expiresOn"));
    }

    @Override
    public String getToken() {
        return this.attributes.entrySet().stream().map(x -> (String)x.getKey() + KEY_VALUE_SEPARATOR + (String)x.getValue()).collect(Collectors.joining(SEPARATOR));
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String toString() {
        return this.getToken();
    }
}

