/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.processor.ODataWriteProcessor;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.processor.write.ActionPostMethodHandler;
import com.sdl.odata.processor.write.DeleteMethodHandler;
import com.sdl.odata.processor.write.PatchMethodHandler;
import com.sdl.odata.processor.write.PostMethodHandler;
import com.sdl.odata.processor.write.PutMethodHandler;
import com.sdl.odata.processor.write.WriteMethodHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ODataWriteProcessorImpl
implements ODataWriteProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ODataWriteProcessorImpl.class);
    @Autowired
    private DataSourceFactory dataSourceFactory;

    public ProcessorResult write(ODataRequestContext requestContext, Object entity) throws ODataException {
        try {
            WriteMethodHandler methodHandler = this.getHandler(requestContext);
            if (methodHandler == null) {
                return new ProcessorResult(ODataResponse.Status.METHOD_NOT_ALLOWED);
            }
            return methodHandler.handleWrite(entity);
        }
        catch (Exception e) {
            LOG.error("Couldn't persist or delete given entity '" + entity + "'", (Throwable)e);
            throw e;
        }
    }

    private WriteMethodHandler getHandler(ODataRequestContext requestContext) {
        ODataRequest.Method method = requestContext.getRequest().getMethod();
        LOG.debug("Requested method is {}", (Object)method);
        switch (method) {
            case POST: {
                if (ODataUriUtil.isActionCallUri((ODataUri)requestContext.getUri())) {
                    LOG.debug("Invoking Action POST method handler");
                    return new ActionPostMethodHandler(requestContext, this.dataSourceFactory);
                }
                return new PostMethodHandler(requestContext, this.dataSourceFactory);
            }
            case PUT: {
                return new PutMethodHandler(requestContext, this.dataSourceFactory);
            }
            case PATCH: {
                return new PatchMethodHandler(requestContext, this.dataSourceFactory);
            }
            case DELETE: {
                return new DeleteMethodHandler(requestContext, this.dataSourceFactory);
            }
        }
        LOG.error("Invalid HTTP method: {}", (Object)method);
        return null;
    }
}

