/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor.write;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.processor.datasource.DataSource;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.processor.link.ODataLink;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.processor.write.WriteMethodHandler;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class DeleteMethodHandler
extends WriteMethodHandler {
    private static Logger log = LoggerFactory.getLogger(DeleteMethodHandler.class);

    public DeleteMethodHandler(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory) {
        super(requestContext, dataSourceFactory);
    }

    @Override
    public ProcessorResult handleWrite(Object entity) throws ODataException {
        if (ODataUriUtil.isRefPathUri((ODataUri)this.getoDataUri())) {
            return this.processLink((ODataLink)entity);
        }
        if (entity != null) {
            throw new ODataBadRequestException("The body of a DELETE request must be empty.");
        }
        return this.processEntity();
    }

    private ProcessorResult processEntity() throws ODataException {
        TargetType targetType = this.getTargetType();
        if (!targetType.isCollection()) {
            Option singletonName = ODataUriUtil.getSingletonName((ODataUri)this.getoDataUri());
            if (singletonName.isDefined()) {
                throw new ODataBadRequestException("The URI refers to the singleton '" + (String)singletonName.get() + "'. Singletons cannot be deleted.");
            }
            Type type = this.getEntityDataModel().getType(targetType.typeName());
            DataSource dataSource = this.getDataSource(type.getFullyQualifiedName());
            log.debug("Data source found for entity type '{}'", (Object)type.getFullyQualifiedName());
            dataSource.delete(this.getoDataUri(), this.getEntityDataModel());
            return new ProcessorResult(ODataResponse.Status.NO_CONTENT);
        }
        throw new ODataBadRequestException("The URI for a DELETE request should refer to the single entity to be deleted, not to a collection of entities.");
    }

    private ProcessorResult processLink(ODataLink link) throws ODataException {
        if (!link.fromNavigationProperty().isCollection() && !link.fromNavigationProperty().isNullable()) {
            throw new ODataBadRequestException("The link cannot be deleted, because the navigation property is not nullable: " + link.fromNavigationProperty() + " in the type: " + link.fromEntityType());
        }
        EntityType entityType = EntityDataModelUtil.getAndCheckEntityType((EntityDataModel)this.getEntityDataModel(), (String)this.getTargetType().typeName());
        DataSource dataSource = this.getDataSource(entityType.getFullyQualifiedName());
        log.debug("Deleting link: {}", (Object)link);
        dataSource.deleteLink(this.getoDataUri(), link, this.getEntityDataModel());
        return new ProcessorResult(ODataResponse.Status.NO_CONTENT);
    }
}

