/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.Function;
import com.sdl.odata.api.edm.model.FunctionImport;
import com.sdl.odata.api.edm.model.Operation;
import com.sdl.odata.api.edm.model.Parameter;
import com.sdl.odata.api.edm.model.Schema;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.util.ParameterTypeUtil;
import com.sdl.odata.api.processor.ODataFunctionProcessor;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.processor.query.QueryResult;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Map;

@Component
public class ODataFunctionProcessorImpl
implements ODataFunctionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ODataFunctionProcessorImpl.class);
    private static final String TRANSFER_ENCODING_CHUNKED = "chunked";
    @Autowired
    private DataSourceFactory dataSourceFactory;

    public ProcessorResult doFunction(ODataRequestContext requestContext) throws ODataException {
        Object result;
        LOG.debug("Building and executing a function or function import");
        Operation operation = this.getFunctionOrFunctionImportOperation(requestContext);
        try {
            boolean isChunkedRequest;
            String te = requestContext.getRequest().getHeader("TE");
            String xte = requestContext.getRequest().getHeader("X-Odata-TE");
            boolean bl = isChunkedRequest = TRANSFER_ENCODING_CHUNKED.equals(te) || TRANSFER_ENCODING_CHUNKED.equals(xte);
            result = isChunkedRequest ? operation.doStreamOperation(requestContext, this.dataSourceFactory) : operation.doOperation(requestContext, this.dataSourceFactory);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception when executing a function " + operation.getClass().getCanonicalName(), (Throwable)e);
            throw e;
        }
        return result == null ? new ProcessorResult(ODataResponse.Status.NO_CONTENT) : new ProcessorResult(ODataResponse.Status.OK, QueryResult.from((Object)result));
    }

    private Operation getFunctionOrFunctionImportOperation(ODataRequestContext context) throws ODataException {
        Operation functionOperation = this.processFunctionCall(context);
        if (functionOperation != null) {
            return functionOperation;
        }
        Operation functionImportOperation = this.processImportCall(context);
        if (functionImportOperation != null) {
            return functionImportOperation;
        }
        throw new ODataBadRequestException("Neither target function nor import can be determined from URI " + context.getUri());
    }

    private Operation processImportCall(ODataRequestContext requestContext) throws ODataEdmException, ODataUnmarshallingException {
        Option functionImportCallName = ODataUriUtil.getFunctionImportCallName((ODataUri)requestContext.getUri());
        if (!functionImportCallName.isDefined()) {
            return null;
        }
        String functionImportName = (String)functionImportCallName.get();
        FunctionImport functionImport = requestContext.getEntityDataModel().getEntityContainer().getFunctionImport(functionImportName);
        Operation functionImportOperation = (Operation)this.initializeFunctionObject(functionImport.getFunction());
        this.fillOperationParameters(functionImportOperation, (Option<scala.collection.immutable.Map<String, String>>)ODataUriUtil.getFunctionImportCallParameters((ODataUri)requestContext.getUri()), functionImport.getFunction().getParameters());
        return functionImportOperation;
    }

    private Operation processFunctionCall(ODataRequestContext context) throws ODataEdmException, ODataUnmarshallingException {
        Option functionCallName = ODataUriUtil.getFunctionCallName((ODataUri)context.getUri());
        if (!functionCallName.isDefined()) {
            return null;
        }
        String functionName = (String)functionCallName.get();
        int lastNamespaceIndex = functionName.lastIndexOf(46);
        String namespace = functionName.substring(0, lastNamespaceIndex);
        String simpleFunctionName = functionName.substring(lastNamespaceIndex + 1);
        Schema schema = context.getEntityDataModel().getSchema(namespace);
        if (schema == null) {
            throw new IllegalArgumentException("Could not find schema with namespace: " + namespace + " from URI " + context.getUri());
        }
        Function function = schema.getFunction(simpleFunctionName);
        Operation functionOperation = (Operation)this.initializeFunctionObject(function);
        this.fillOperationParameters(functionOperation, (Option<scala.collection.immutable.Map<String, String>>)ODataUriUtil.getFunctionCallParameters((ODataUri)context.getUri()), function.getParameters());
        return functionOperation;
    }

    private Object initializeFunctionObject(Function function) throws ODataEdmException {
        Object operation;
        try {
            operation = function.getJavaClass().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new ODataEdmException("Error during initialization of OData Function instance: " + function.getName(), (Throwable)e);
        }
        if (!(operation instanceof Operation)) {
            throw new ODataEdmException("The initialized OData Function with name: " + function.getName() + " does not implement Operation interface");
        }
        return operation;
    }

    private void fillOperationParameters(Object functionOperationObject, Option<scala.collection.immutable.Map<String, String>> functionCallParameters, Set<Parameter> parameters) throws ODataUnmarshallingException {
        StringBuilder validationMessage = new StringBuilder();
        if (functionCallParameters.isDefined() && !((scala.collection.immutable.Map)functionCallParameters.get()).isEmpty()) {
            java.util.Map parametersMap = JavaConverters.mapAsJavaMap((Map)((Map)functionCallParameters.get()));
            this.validateAndSetParameters(functionOperationObject, parameters, parametersMap, validationMessage);
        } else {
            this.validateAndSetParameters(functionOperationObject, parameters, null, validationMessage);
        }
        if (!"".equals(validationMessage.toString())) {
            this.throwValidationException(validationMessage);
        }
    }

    private void validateAndSetParameters(Object functionOperationObject, Set<Parameter> parameters, java.util.Map<String, String> parametersMap, StringBuilder validationMessage) throws ODataUnmarshallingException {
        if (parametersMap == null) {
            parameters.stream().filter(parameter -> !parameter.isNullable()).forEach(parameter -> validationMessage.append(parameter.getName() + ", "));
        } else {
            for (Parameter parameter2 : parameters) {
                String parameterName = parameter2.getName();
                String parameterValue = parametersMap.get(parameterName);
                if (!parameter2.isNullable() && parameterValue == null) {
                    validationMessage.append(parameterName + ", ");
                }
                if (parameterValue == null) continue;
                ParameterTypeUtil.setParameter((Object)functionOperationObject, (Field)parameter2.getJavaField(), (Object)parameterValue);
            }
        }
    }

    private void throwValidationException(StringBuilder validationMessage) throws ODataUnmarshallingException {
        validationMessage.insert(0, "Cannot send null value for not nullable field(s) ");
        throw new ODataUnmarshallingException(validationMessage.delete(validationMessage.lastIndexOf(", "), validationMessage.length()).toString());
    }
}

