/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.processor.write;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.processor.datasource.DataSource;
import com.sdl.odata.api.processor.datasource.ODataTargetTypeException;
import com.sdl.odata.api.processor.datasource.TransactionalDataSource;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.processor.query.QueryResult;
import com.sdl.odata.api.service.ChangeSetEntity;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.processor.write.util.WriteMethodUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class BatchMethodHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BatchMethodHandler.class);
    private final List<ChangeSetEntity> changeSetEntities;
    private final EntityDataModel entityDataModel;
    private final DataSourceFactory dataSourceFactory;
    private final Map<String, TransactionalDataSource> dataSourceMap = new HashMap<String, TransactionalDataSource>();

    public BatchMethodHandler(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory, List<ChangeSetEntity> changeSetEntries) {
        this.changeSetEntities = changeSetEntries;
        this.entityDataModel = requestContext.getEntityDataModel();
        this.dataSourceFactory = dataSourceFactory;
    }

    public List<ProcessorResult> handleWrite() throws ODataException {
        LOG.debug("Handling transactional operations per each odata request.");
        ArrayList<ProcessorResult> resultList = new ArrayList<ProcessorResult>();
        try {
            for (ChangeSetEntity changeSetEntity : this.changeSetEntities) {
                ODataRequestContext odataRequestContext = changeSetEntity.getRequestContext();
                ODataUri requestUri = odataRequestContext.getUri();
                ODataRequest.Method method = odataRequestContext.getRequest().getMethod();
                ProcessorResult result = null;
                if (method == ODataRequest.Method.POST) {
                    result = this.handlePOST(odataRequestContext, requestUri, changeSetEntity);
                } else if (method == ODataRequest.Method.PUT || method == ODataRequest.Method.PATCH) {
                    result = this.handlePutAndPatch(odataRequestContext, requestUri, changeSetEntity);
                } else if (method == ODataRequest.Method.DELETE) {
                    result = this.handleDelete(odataRequestContext, requestUri, changeSetEntity);
                }
                resultList.add(result);
            }
            this.commitTransactions();
        }
        catch (ODataException e) {
            LOG.error("Transaction could not be processed, rolling back", (Throwable)e);
            this.rollbackTransactions();
            throw e;
        }
        return resultList;
    }

    private ProcessorResult handlePOST(ODataRequestContext oDataRequestContext, ODataUri oDataUri, ChangeSetEntity changeSetEntity) throws ODataException {
        LOG.debug("Handling POST operation");
        Object entityData = changeSetEntity.getOdataEntity();
        Map<String, String> headers = this.buildDefaultEntityHeaders(oDataRequestContext, changeSetEntity);
        ODataRequest oDataRequest = oDataRequestContext.getRequest();
        this.validateEntityData(oDataRequest, oDataUri, entityData);
        TransactionalDataSource dataSource = this.getTransactionalDataSource(oDataRequestContext, this.getRequestType(oDataRequest, oDataUri));
        headers.putAll(oDataRequest.getHeaders());
        headers.put("changeSetId", changeSetEntity.getChangeSetId());
        Object createdEntity = dataSource.create(oDataUri, entityData, this.entityDataModel);
        if (WriteMethodUtil.isMinimalReturnPreferred(oDataRequest)) {
            return new ProcessorResult(ODataResponse.Status.NO_CONTENT, headers);
        }
        return new ProcessorResult(ODataResponse.Status.CREATED, QueryResult.from((Object)createdEntity), headers, oDataRequestContext);
    }

    private ProcessorResult handleDelete(ODataRequestContext odataRequestContext, ODataUri odataUri, ChangeSetEntity changeSetEntity) throws ODataException {
        LOG.debug("Handling DELETE operation");
        Map<String, String> headers = this.buildDefaultEntityHeaders(odataRequestContext, changeSetEntity);
        Option singletonName = ODataUriUtil.getSingletonName((ODataUri)odataUri);
        TransactionalDataSource dataSource = this.getTransactionalDataSource(odataRequestContext, this.getRequestType(odataRequestContext.getRequest(), odataUri));
        if (singletonName.isDefined()) {
            throw new ODataBadRequestException("The URI refers to the singleton '" + (String)singletonName.get() + "'. Singletons cannot be deleted.");
        }
        dataSource.delete(odataUri, this.entityDataModel);
        return new ProcessorResult(ODataResponse.Status.NO_CONTENT, null, headers, odataRequestContext);
    }

    private ProcessorResult handlePutAndPatch(ODataRequestContext odataRequestContext, ODataUri requestUri, ChangeSetEntity changeSetEntity) throws ODataException {
        LOG.debug("Handling PUT or PATCH operation");
        Object entityData = changeSetEntity.getOdataEntity();
        ODataRequest oDataRequest = odataRequestContext.getRequest();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("changeSetId", changeSetEntity.getChangeSetId());
        this.validateEntityData(oDataRequest, requestUri, entityData);
        TargetType targetType = WriteMethodUtil.getTargetType(oDataRequest, this.entityDataModel, requestUri);
        if (targetType.isCollection()) {
            throw new ODataBadRequestException("The URI for a PATCH request should refer to the single entity to be updated, not to a collection of entities.");
        }
        headers.putAll(WriteMethodUtil.getResponseHeaders(entityData, requestUri, this.entityDataModel));
        WriteMethodUtil.validateTargetType(entityData, oDataRequest, this.entityDataModel, requestUri);
        Type type = this.entityDataModel.getType(targetType.typeName());
        WriteMethodUtil.validateKeys(entityData, (EntityType)type, requestUri, this.entityDataModel);
        TransactionalDataSource dataSource = this.getTransactionalDataSource(odataRequestContext, type);
        Object updatedEntity = dataSource.update(requestUri, entityData, this.entityDataModel);
        headers.putAll(oDataRequest.getHeaders());
        if (WriteMethodUtil.isMinimalReturnPreferred(oDataRequest)) {
            return new ProcessorResult(ODataResponse.Status.NO_CONTENT, headers);
        }
        return new ProcessorResult(ODataResponse.Status.OK, QueryResult.from((Object)updatedEntity), headers, odataRequestContext);
    }

    private Map<String, String> buildDefaultEntityHeaders(ODataRequestContext odataRequestContext, ChangeSetEntity changeSetEntity) {
        HashMap<String, String> headers = new HashMap<String, String>();
        ODataRequest oDataRequest = odataRequestContext.getRequest();
        headers.putAll(oDataRequest.getHeaders());
        headers.put("changeSetId", changeSetEntity.getChangeSetId());
        return headers;
    }

    private void commitTransactions() {
        LOG.debug("Committing batch transactions");
        this.dataSourceMap.values().forEach(TransactionalDataSource::commit);
    }

    private void rollbackTransactions() {
        LOG.warn("Rolling back batch transactions");
        this.dataSourceMap.values().forEach(TransactionalDataSource::rollback);
    }

    private Type getRequestType(ODataRequest oDataRequest, ODataUri oDataUri) throws ODataTargetTypeException {
        TargetType targetType = WriteMethodUtil.getTargetType(oDataRequest, this.entityDataModel, oDataUri);
        return this.entityDataModel.getType(targetType.typeName());
    }

    private TransactionalDataSource getTransactionalDataSource(ODataRequestContext odataRequestContext, Type type) throws ODataException {
        DataSource dataSource = this.dataSourceFactory.getDataSource(odataRequestContext, type.getFullyQualifiedName());
        String dataSourceKey = dataSource.getClass().toString();
        if (this.dataSourceMap.containsKey(dataSourceKey)) {
            return this.dataSourceMap.get(dataSourceKey);
        }
        TransactionalDataSource transactionalDataSource = dataSource.startTransaction();
        this.dataSourceMap.put(dataSourceKey, transactionalDataSource);
        return transactionalDataSource;
    }

    private void validateEntityData(ODataRequest oDataRequest, ODataUri oDataUri, Object entityData) throws ODataException {
        Type targetType = this.getRequestType(oDataRequest, oDataUri);
        if (!MetaType.ENTITY.equals((Object)targetType.getMetaType())) {
            throw new ODataBadRequestException("The body of the write request must contain a valid entity.");
        }
        WriteMethodUtil.validateProperties(entityData, this.entityDataModel);
    }
}

