/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.test.util;

import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.parser.CompoundKeyPredicate;
import com.sdl.odata.api.parser.CountPath$;
import com.sdl.odata.api.parser.EntityCollectionPath;
import com.sdl.odata.api.parser.EntitySetPath;
import com.sdl.odata.api.parser.ExpandOption;
import com.sdl.odata.api.parser.ExpandPathSegment;
import com.sdl.odata.api.parser.KeyPredicate;
import com.sdl.odata.api.parser.KeyPredicatePath;
import com.sdl.odata.api.parser.Literal;
import com.sdl.odata.api.parser.MetadataUri;
import com.sdl.odata.api.parser.NavigationPropertyExpandPathSegment;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.PathExpandItem;
import com.sdl.odata.api.parser.PropertyPath;
import com.sdl.odata.api.parser.PropertyPath$;
import com.sdl.odata.api.parser.RelativeUri;
import com.sdl.odata.api.parser.ResourcePath;
import com.sdl.odata.api.parser.ResourcePathUri;
import com.sdl.odata.api.parser.ServiceRootUri;
import com.sdl.odata.api.parser.SimpleKeyPredicate;
import com.sdl.odata.api.parser.StringLiteral;
import com.sdl.odata.api.parser.ValuePath$;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.test.model.AbstractComplexTypeSample;
import com.sdl.odata.test.model.AbstractEntityTypeSample;
import com.sdl.odata.test.model.ActionImportSample;
import com.sdl.odata.test.model.ActionSample;
import com.sdl.odata.test.model.Address;
import com.sdl.odata.test.model.BankAccount;
import com.sdl.odata.test.model.Category;
import com.sdl.odata.test.model.CollectionsSample;
import com.sdl.odata.test.model.ComplexKeySample;
import com.sdl.odata.test.model.ComplexTypeSample;
import com.sdl.odata.test.model.ComplexTypeSampleList;
import com.sdl.odata.test.model.Customer;
import com.sdl.odata.test.model.EntityTypeSample;
import com.sdl.odata.test.model.EnumSample;
import com.sdl.odata.test.model.ExpandedPropertiesSample;
import com.sdl.odata.test.model.FunctionImportSample;
import com.sdl.odata.test.model.FunctionSample;
import com.sdl.odata.test.model.IdNamePairComplex;
import com.sdl.odata.test.model.IdNamePairSample;
import com.sdl.odata.test.model.Order;
import com.sdl.odata.test.model.PrimitiveTypesSample;
import com.sdl.odata.test.model.Product;
import com.sdl.odata.test.model.SingletonSample;
import com.sdl.odata.test.model.UnboundActionSample;
import com.sdl.odata.test.model.UnboundFunctionSample;
import com.sdl.odata.test.model.complex.ODataDemoClassification;
import com.sdl.odata.test.model.complex.ODataDemoEntity;
import com.sdl.odata.test.model.complex.ODataDemoProperty;
import com.sdl.odata.test.model.complex.ODataDemoPropertyType;
import com.sdl.odata.test.model.complex.ODataDemoPropertyValue;
import com.sdl.odata.test.model.complex.ODataVersion;
import com.sdl.odata.test.model.complex.ODataVersionPart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scala.Option;
import scala.collection.immutable.List$;

public final class TestUtils {
    private static final int SIZE = 4096;
    public static final String SERVICE_ROOT = "http://localhost:8080/odata.svc";

    private TestUtils() {
    }

    public static List<Class<?>> getEdmEntityClasses() {
        return Arrays.asList(Customer.class, AbstractComplexTypeSample.class, ComplexTypeSample.class, ComplexTypeSampleList.class, AbstractEntityTypeSample.class, EntityTypeSample.class, Address.class, Order.class, Product.class, Category.class, BankAccount.class, PrimitiveTypesSample.class, CollectionsSample.class, EnumSample.class, IdNamePairSample.class, IdNamePairComplex.class, ExpandedPropertiesSample.class, ComplexKeySample.class, SingletonSample.class, FunctionSample.class, UnboundFunctionSample.class, FunctionImportSample.class, ActionSample.class, UnboundActionSample.class, ActionImportSample.class, ODataDemoProperty.class, ODataDemoPropertyType.class, ODataDemoEntity.class, ODataDemoPropertyValue.class, ODataVersion.class, ODataVersionPart.class, ODataDemoClassification.class);
    }

    public static ODataUri createODataUri(MediaType ... mediaTypes) {
        return TestUtils.createODataUriForServiceDocument(SERVICE_ROOT, mediaTypes);
    }

    public static ODataUri createODataUri(String serviceRoot, MediaType ... mediaTypes) {
        return TestUtils.createODataUriForServiceDocument(serviceRoot, mediaTypes);
    }

    public static ODataUri createODataUriForMetaData() {
        Option format = Option.apply(null);
        Option context = Option.apply(null);
        return new ODataUri(SERVICE_ROOT, (RelativeUri)new MetadataUri(format, context));
    }

    public static ODataUri createODataUriForServiceDocument(MediaType ... mediaTypes) {
        return TestUtils.createODataUriForServiceDocument(SERVICE_ROOT, mediaTypes);
    }

    public static ODataUri createODataUriForServiceDocument(String serviceRoot, MediaType ... mediaTypes) {
        Option format = Option.apply(null);
        if (mediaTypes.length > 0) {
            format = Option.apply((Object)mediaTypes[0]);
        }
        return new ODataUri(serviceRoot, (RelativeUri)new ServiceRootUri(format));
    }

    public static ODataUri createODataUriWithSimpleKeyPredicate(String entitySetName) {
        Option none = Option.apply(null);
        Option noneSubPath = Option.apply(null);
        KeyPredicatePath keyPredicatePath = new KeyPredicatePath((KeyPredicate)new SimpleKeyPredicate((Literal)new StringLiteral("1")), noneSubPath);
        EntityCollectionPath collectionPath = new EntityCollectionPath(none, Option.apply((Object)keyPredicatePath));
        EntitySetPath entitySetPath = new EntitySetPath(entitySetName, Option.apply((Object)collectionPath));
        ResourcePathUri resourcePathUri = new ResourcePathUri((ResourcePath)entitySetPath, ODataUriUtil.asScalaList(new ArrayList()));
        return new ODataUri(SERVICE_ROOT, (RelativeUri)resourcePathUri);
    }

    public static ODataRequest createODataRequest(ODataRequest.Method method, Map<String, String> headers) throws UnsupportedEncodingException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        return new ODataRequest.Builder().setBodyText("test", "UTF-8").setUri(SERVICE_ROOT).setHeaders(headers).setMethod(method).build();
    }

    public static ODataUri createODataUriEntityKeys(String serviceRoot, String entitySetName, KeyValuePair ... keyValuePairs) {
        Option noEntityPath = Option.apply(null);
        KeyPredicate keyPredicate = TestUtils.createKeyPredicate(keyValuePairs);
        KeyPredicatePath keyPredicatePath = new KeyPredicatePath(keyPredicate, noEntityPath);
        Option noString = Option.apply(null);
        Option keyPredicatePathOption = Option.apply((Object)keyPredicatePath);
        EntityCollectionPath entityCollectionPath = new EntityCollectionPath(noString, keyPredicatePathOption);
        Option entityCollectionPathOption = Option.apply((Object)entityCollectionPath);
        EntitySetPath entitySetPath = new EntitySetPath(entitySetName, entityCollectionPathOption);
        ArrayList queryOptions = new ArrayList();
        ResourcePathUri resourcePathUri = new ResourcePathUri((ResourcePath)entitySetPath, ODataUriUtil.asScalaList(queryOptions));
        return new ODataUri(serviceRoot, (RelativeUri)resourcePathUri);
    }

    public static ODataUri createODataCountEntitiesUri(String serviceRoot, String entitySetName) {
        CountPath$ countPath = CountPath$.MODULE$;
        Option countPathOption = Option.apply((Object)countPath);
        Option noString = Option.apply(null);
        EntityCollectionPath entityCollectionPath = new EntityCollectionPath(noString, countPathOption);
        Option entityCollectionPathOption = Option.apply((Object)entityCollectionPath);
        EntitySetPath entitySetPath = new EntitySetPath(entitySetName, entityCollectionPathOption);
        ArrayList queryOptions = new ArrayList();
        ResourcePathUri resourcePathUri = new ResourcePathUri((ResourcePath)entitySetPath, ODataUriUtil.asScalaList(queryOptions));
        return new ODataUri(serviceRoot, (RelativeUri)resourcePathUri);
    }

    public static ODataUri createODataValueEntitiesUri(String serviceRoot, String entitySetName, String propertyName) {
        ValuePath$ valuePath = ValuePath$.MODULE$;
        Option valuePathOption = Option.apply((Object)valuePath);
        PropertyPath propertyPath = PropertyPath$.MODULE$.apply(propertyName, valuePathOption);
        Option propertyPathOption = Option.apply((Object)propertyPath);
        Option noString = Option.apply(null);
        EntityCollectionPath entityCollectionPath = new EntityCollectionPath(noString, propertyPathOption);
        Option entityCollectionPathOption = Option.apply((Object)entityCollectionPath);
        EntitySetPath entitySetPath = new EntitySetPath(entitySetName, entityCollectionPathOption);
        ArrayList queryOptions = new ArrayList();
        ResourcePathUri resourcePathUri = new ResourcePathUri((ResourcePath)entitySetPath, ODataUriUtil.asScalaList(queryOptions));
        return new ODataUri(serviceRoot, (RelativeUri)resourcePathUri);
    }

    private static KeyPredicate createKeyPredicate(KeyValuePair ... keyValuePairs) {
        if (keyValuePairs.length == 1) {
            return new SimpleKeyPredicate(keyValuePairs[0].getValue());
        }
        HashMap<String, Literal> keyValues = new HashMap<String, Literal>();
        for (KeyValuePair keyValuePair : keyValuePairs) {
            keyValues.put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        return new CompoundKeyPredicate(ODataUriUtil.asScalaMap(keyValues));
    }

    public static ODataUri createODataUri(String serviceRoot, String entitySetName, String ... expandPathNames) {
        Option none = Option.apply(null);
        ArrayList<PathExpandItem> expandItems = new ArrayList<PathExpandItem>();
        for (String expandPathName : expandPathNames) {
            NavigationPropertyExpandPathSegment path = new NavigationPropertyExpandPathSegment(expandPathName, none);
            expandItems.add(new PathExpandItem(none, (ExpandPathSegment)path, List$.MODULE$.empty()));
        }
        ExpandOption expandOption = new ExpandOption(ODataUriUtil.asScalaList(expandItems));
        ArrayList<ExpandOption> queryOptions = new ArrayList<ExpandOption>();
        queryOptions.add(expandOption);
        EntitySetPath entitySetPath = new EntitySetPath(entitySetName, null);
        ResourcePathUri resourcePathUri = new ResourcePathUri((ResourcePath)entitySetPath, ODataUriUtil.asScalaList(queryOptions));
        return new ODataUri(serviceRoot, (RelativeUri)resourcePathUri);
    }

    public static ODataUri createODataUri(String serviceRoot, String entitySetName) {
        ArrayList queryOptions = new ArrayList();
        EntitySetPath entitySetPath = new EntitySetPath(entitySetName, Option.apply(null));
        ResourcePathUri resourcePathUri = new ResourcePathUri((ResourcePath)entitySetPath, ODataUriUtil.asScalaList(queryOptions));
        return new ODataUri(serviceRoot, (RelativeUri)resourcePathUri);
    }

    public static ODataRequest createODataRequest(String uri, ODataRequest.Method method) throws UnsupportedEncodingException {
        return new ODataRequest.Builder().setBodyText("test", "UTF-8").setUri(uri).setMethod(method).build();
    }

    public static ODataRequest createODataRequest(ODataRequest.Method method, MediaType ... mediaTypes) throws UnsupportedEncodingException {
        return TestUtils.createODataRequest(method, null, mediaTypes);
    }

    public static ODataRequest createODataRequest(ODataRequest.Method method, Map<String, String> headers, MediaType ... mediaTypes) throws UnsupportedEncodingException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        return new ODataRequest.Builder().setBodyText("test", "UTF-8").setUri(SERVICE_ROOT).setAccept(mediaTypes).setMethod(method).setHeaders(headers).build();
    }

    public static ODataRequest createODataRequestWithContentType(ODataRequest.Method method, MediaType contentType) throws UnsupportedEncodingException {
        return new ODataRequest.Builder().setBodyText("test", "UTF-8").setUri(SERVICE_ROOT).setContentType(contentType).setMethod(method).build();
    }

    public static ODataRequest createSimpleODataRequest(ODataRequest.Method method) throws UnsupportedEncodingException {
        return new ODataRequest.Builder().setBodyText("test", "UTF-8").setUri(SERVICE_ROOT).setMethod(method).build();
    }

    public static ODataRequestContext createODataRequestContext(ODataRequest.Method method, EntityDataModel entityDataModel) throws UnsupportedEncodingException {
        return new ODataRequestContext(TestUtils.createODataRequest(method, new MediaType[0]), TestUtils.createODataUri(new MediaType[0]), entityDataModel);
    }

    public static ODataRequestContext createODataRequestContext(ODataRequest.Method method, ODataUri oDataUri, EntityDataModel entityDataModel) throws UnsupportedEncodingException {
        return new ODataRequestContext(TestUtils.createODataRequest(method, new MediaType[0]), oDataUri, entityDataModel);
    }

    public static ODataRequestContext createODataRequestContext(ODataRequest.Method method, ODataUri oDataUri, EntityDataModel entityDataModel, Map<String, String> headers) throws UnsupportedEncodingException {
        return new ODataRequestContext(TestUtils.createODataRequest(method, headers), oDataUri, entityDataModel);
    }

    public static ODataRequestContext createODataRequestContext(ODataRequest request, ODataUri oDataUri, EntityDataModel entityDataModel) throws UnsupportedEncodingException {
        return new ODataRequestContext(request, oDataUri, entityDataModel);
    }

    public static String readContent(String source) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (InputStream inputStream = TestUtils.class.getResourceAsStream(source);){
            TestUtils.copy(inputStream, outputStream);
        }
        return outputStream.toString(Charset.forName("UTF-8").name());
    }

    private static long copy(InputStream is, OutputStream os) throws IOException {
        int r;
        if (is == null) {
            throw new IllegalArgumentException();
        }
        if (os == null) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = is.read(buf)) != -1) {
            os.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static class KeyValuePair {
        private final String key;
        private final Literal value;

        public KeyValuePair(String key, Literal value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Literal getValue() {
            return this.value;
        }
    }
}

