/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.test.model;

import com.sdl.odata.api.edm.annotations.EdmEntity;
import com.sdl.odata.api.edm.annotations.EdmEntitySet;
import com.sdl.odata.api.edm.annotations.EdmNavigationProperty;
import com.sdl.odata.api.edm.annotations.EdmProperty;
import com.sdl.odata.api.edm.model.OnDeleteAction;
import com.sdl.odata.test.model.Address;
import com.sdl.odata.test.model.BankAccount;
import com.sdl.odata.test.model.Order;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

@EdmEntity(namespace="ODataDemo", key={"id"}, containerName="ODataDemoContainer")
@EdmEntitySet(value="Customers")
public class Customer {
    public static final int EDM_MAX_LENGTH = 80;
    public static final String PHONE = "Phone";
    public static final int HASH = 31;
    @EdmProperty(nullable=false)
    private long id;
    @EdmProperty(nullable=false, maxLength=80L)
    private String name;
    @EdmProperty(nullable=true, name="Phone")
    private List<String> phoneNumbers = new ArrayList<String>();
    @EdmProperty(nullable=false)
    private List<Address> address = new ArrayList<Address>();
    @EdmProperty(nullable=false, name="date")
    private ZonedDateTime dateTime;
    @EdmNavigationProperty(name="Orders", nullable=false, partner="customer", onDelete={OnDeleteAction.NONE})
    private List<Order> orders = new ArrayList<Order>();
    @EdmNavigationProperty(name="BankAccount", nullable=true, onDelete={OnDeleteAction.NONE})
    private BankAccount bankAccount;

    public long getId() {
        return this.id;
    }

    public Customer setId(long customerId) {
        this.id = customerId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Customer setName(String customerName) {
        this.name = customerName;
        return this;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public Customer setAddress(List<Address> customerAddress) {
        this.address = customerAddress;
        return this;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public Customer setOrders(List<Order> customerOrders) {
        this.orders = customerOrders;
        return this;
    }

    public Customer setPhoneNumbers(List<String> numbers) {
        this.phoneNumbers = numbers;
        return this;
    }

    public List<String> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public Customer setDateTime(ZonedDateTime dt) {
        this.dateTime = dt;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Customer customer = (Customer)that;
        if (this.id != customer.id) {
            return false;
        }
        if (this.address != null ? !this.address.equals(customer.address) : customer.address != null) {
            return false;
        }
        if (!this.areDatesEqual(customer.dateTime)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(customer.name) : customer.name != null) {
            return false;
        }
        if (this.phoneNumbers != null ? !this.phoneNumbers.equals(customer.phoneNumbers) : customer.phoneNumbers != null) {
            return false;
        }
        return !(this.bankAccount != null ? !this.bankAccount.equals(customer.bankAccount) : customer.bankAccount != null);
    }

    private boolean areDatesEqual(ZonedDateTime that) {
        if (this.dateTime == null && that == null) {
            return true;
        }
        if (this.dateTime != null && that != null) {
            return this.dateTime.equals(that);
        }
        return false;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.phoneNumbers != null ? this.phoneNumbers.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.dateTime != null ? this.dateTime.hashCode() : 0);
        result = 31 * result + (this.orders != null ? this.orders.hashCode() : 0);
        result = 31 * result + (this.bankAccount != null ? this.bankAccount.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Customer{id=" + this.id + ", name='" + this.name + '\'' + ", phoneNumbers=" + this.phoneNumbers + ", address=" + this.address + ", dateTime=" + this.dateTime + ", orders=" + this.orders + ", bankAccount=" + this.bankAccount + '}';
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public Customer setBankAccount(BankAccount account) {
        this.bankAccount = account;
        return this;
    }
}

