/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.webservice;

import java.io.File;
import java.io.IOException;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
public class TomcatConfiguration {
    private static final String HTTPS_SCHEME = "https";
    @Value(value="${https.enabled}")
    private String httpsModeFlag;
    @Value(value="${https.port}")
    private String httpsPort;
    @Value(value="${https.keystore-passwd}")
    private String keystorePasswd;
    @Value(value="${https.keystore-path}")
    private String keystorePath;
    @Value(value="${https.truststore-passwd}")
    private String truststorePasswd;
    @Value(value="${https.key-alias}")
    private String keyAlias;

    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
        if (Boolean.parseBoolean(this.httpsModeFlag)) {
            tomcat.addAdditionalTomcatConnectors(new Connector[]{this.createSslConnector()});
        }
        return tomcat;
    }

    private Connector createSslConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        try {
            File keystore = new ClassPathResource(this.keystorePath).getFile();
            connector.setScheme(HTTPS_SCHEME);
            connector.setSecure(true);
            connector.setPort(Integer.parseInt(this.httpsPort));
            protocol.setSSLEnabled(true);
            protocol.setKeystoreFile(keystore.getAbsolutePath());
            protocol.setKeystorePass(this.keystorePasswd);
            protocol.setTruststoreFile(keystore.getAbsolutePath());
            protocol.setTruststorePass(this.truststorePasswd);
            protocol.setKeyAlias(this.keyAlias);
            return connector;
        }
        catch (IOException ex) {
            throw new IllegalStateException("cant access keystore: [keystore] or truststore: [keystore]", ex);
        }
    }
}

