/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.image.filter;

import com.sdl.odata.client.URLConnectionRequestPropertiesBuilder;
import com.sdl.web.client.CapabilityProvider;
import com.sdl.web.client.configuration.XMLConfigurationHolder;
import com.sdl.web.client.configuration.XMLConfigurationReaderImpl;
import com.sdl.web.client.configuration.api.ConfigurationException;
import com.sdl.web.client.configuration.api.ConfigurationHolder;
import com.sdl.web.client.impl.CapabilityProviderFactory;
import com.sdl.web.client.impl.OAuthTokenProvider;
import com.sdl.web.discovery.datalayer.model.Capability;
import com.sdl.web.discovery.datalayer.model.ContextualImageDeliveryCapability;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualImageFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ContextualImageFilter.class);
    private static final String CLIENT_CONFIG = "cd_client_conf.xml";
    private static final String DISCOVERY_SERVICE_ELEM = "/DiscoveryService";
    private static final String TOKEN_SERVICE_ELEM = "/TokenService";
    private static final String SET_COOKIE_HEADER_NAME = "Set-Cookie";
    private static final String SESSION_ID_HEADER_VALUE_STARTS_WITH = "SESSIONID";
    private String filterMapping;
    private String cidUrl;
    private HttpHost cidHost;
    private Optional<OAuthTokenProvider> oAuthTokenProvider = Optional.empty();

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("Initializing Contextual Image Filter.");
        this.filterMapping = this.getFilterMapping(filterConfig);
        this.cidUrl = this.getContextualImageServiceURL();
        try {
            this.cidHost = URIUtils.extractHost((URI)new URI(this.cidUrl));
        }
        catch (URISyntaxException e) {
            LOG.error("Failed to identify host Contextual Image Service. {}", (Object)e.getMessage());
            throw new ServletException("Failed to identify host Contextual Image Service.");
        }
        LOG.info("Contextual Image Filter initialized.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug("Processing Contextual Image Filter start.");
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        String servletPath = servletRequest.getServletPath();
        String cidURL = this.cidUrl + servletPath.substring(this.filterMapping.length());
        LOG.debug("Send request to Contextual Image Service.");
        HttpResponse proxyResponse = null;
        try {
            BasicHttpRequest proxyRequest = new BasicHttpRequest(servletRequest.getMethod(), cidURL);
            if (this.oAuthTokenProvider.isPresent()) {
                String oAuthToken = this.oAuthTokenProvider.get().getToken();
                new URLConnectionRequestPropertiesBuilder().withAccessToken(oAuthToken).build().forEach((arg_0, arg_1) -> ((HttpRequest)proxyRequest).addHeader(arg_0, arg_1));
            }
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            proxyResponse = httpClient.execute(this.cidHost, (HttpRequest)proxyRequest);
            servletResponse.setStatus(proxyResponse.getStatusLine().getStatusCode());
            for (Header header : proxyResponse.getAllHeaders()) {
                if (SET_COOKIE_HEADER_NAME.equals(header.getName()) && header.getValue() != null && header.getValue().startsWith(SESSION_ID_HEADER_VALUE_STARTS_WITH)) continue;
                servletResponse.addHeader(header.getName(), header.getValue());
            }
            HttpEntity entity = proxyResponse.getEntity();
            if (entity != null) {
                entity.writeTo((OutputStream)servletResponse.getOutputStream());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to connect to Context Image Service. {}", (Object)e.getMessage());
            throw new ServletException("Failed to connect to Context Image Service.");
        }
        finally {
            if (proxyResponse != null) {
                EntityUtils.consume((HttpEntity)proxyResponse.getEntity());
            }
        }
        LOG.debug("Contextual Image Filter execution complete.");
    }

    public void destroy() {
    }

    private String getFilterMapping(FilterConfig filterConfig) throws ServletException {
        LOG.debug("Get mapping of ContextualImageFilter.");
        String filterName = filterConfig.getFilterName();
        ServletContext servletContext = filterConfig.getServletContext();
        Collection filterMappings = ((FilterRegistration)servletContext.getFilterRegistrations().get(filterName)).getUrlPatternMappings();
        if (filterMappings.size() != 1) {
            LOG.error("ContextualImageFilter should be mapped with single url. {}", (Object)filterMappings);
            throw new ServletException("ContextualImageFilter should be mapped with single url.");
        }
        String mapping = (String)filterMappings.iterator().next();
        mapping = mapping.substring(0, mapping.lastIndexOf("/"));
        LOG.debug("Mapping of ContextualImageFilter: {}.", (Object)mapping);
        return mapping;
    }

    private String getContextualImageServiceURL() throws ServletException {
        LOG.debug("Reading configuration from file: {}", (Object)CLIENT_CONFIG);
        try {
            XMLConfigurationHolder rootConfig = new XMLConfigurationReaderImpl().readConfiguration(CLIENT_CONFIG);
            String discoveryURL = rootConfig.getConfiguration(DISCOVERY_SERVICE_ELEM).getValue("ServiceUri");
            Properties properties = this.initializeProperties((ConfigurationHolder)rootConfig, discoveryURL);
            if (this.hasOAuthProperties(properties)) {
                this.oAuthTokenProvider = Optional.of(new OAuthTokenProvider(properties));
            }
            ContextualImageDeliveryCapability capability = this.getCapability(discoveryURL, properties, ContextualImageDeliveryCapability.class);
            LOG.debug("URL to Contextual Image Service: {}.", (Object)capability.getUri());
            return capability.getUri();
        }
        catch (ConfigurationException e) {
            LOG.error("Unable to get URL of Contextual Image Service: {}.", (Object)e.getMessage());
            throw new ServletException("Unable to get URL to Contextual Image Service.");
        }
    }

    private Properties initializeProperties(ConfigurationHolder rootConfig, String discoveryURL) throws ConfigurationException {
        Properties properties = new Properties();
        properties.put("ServiceUri", discoveryURL);
        properties.put("ConnectionTimeout", rootConfig.getValue("ConnectionTimeout"));
        properties.put("CacheEnabled", rootConfig.getValue("CacheEnabled"));
        properties.put("CacheUri", rootConfig.getValue("CacheUri"));
        properties.put("CacheExpirationDuration", rootConfig.getValue("CacheExpirationDuration"));
        properties.put("CacheConnectionTimeout", rootConfig.getValue("CacheConnectionTimeout"));
        properties.put("CacheProviderClass", rootConfig.getValue("CacheProviderClass"));
        properties.put("CacheClientId", rootConfig.getValue("CacheClientId"));
        properties.put("CachePassword", rootConfig.getValue("CachePassword"));
        if (rootConfig.hasConfiguration(TOKEN_SERVICE_ELEM)) {
            ConfigurationHolder tokenServiceConfig = rootConfig.getConfiguration(TOKEN_SERVICE_ELEM);
            properties.put("ClientId", tokenServiceConfig.getValue("ClientId"));
            properties.put("ClientSecret", tokenServiceConfig.getValue("ClientSecret"));
            properties.put("ServiceUri", discoveryURL);
        }
        return properties;
    }

    private <T extends Capability> T getCapability(String discoveryURL, Properties properties, Class<T> capability) throws ConfigurationException {
        LOG.debug("Start looking for capability: {}", (Object)capability.getSimpleName());
        try {
            CapabilityProvider provider = this.oAuthTokenProvider.isPresent() ? CapabilityProviderFactory.getCachingSecuredCapabilityProvider((Properties)properties) : CapabilityProviderFactory.getCachingDefaultCapabilityProvider((Properties)properties);
            Optional resolvedCapability = provider.getCapability(capability);
            if (resolvedCapability.isPresent()) {
                LOG.debug("Capability {} resolved using DiscoveryService: {}.", resolvedCapability.get(), (Object)discoveryURL);
                return (T)((Capability)resolvedCapability.get());
            }
        }
        catch (Exception e) {
            LOG.error("Unable to resolve {} using DiscoveryService: {}.", new Object[]{capability.getSimpleName(), discoveryURL, e});
        }
        LOG.error("Unable to get Contextual Image Service URL.");
        throw new ConfigurationException("Unable to get Contextual Image Service URL.");
    }

    private boolean hasOAuthProperties(Properties properties) {
        return properties.containsKey("ServiceUri") && properties.containsKey("ClientId") && properties.containsKey("ClientSecret");
    }
}

