/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.compression;

public class LookbackBuffer {
    private final int sz;
    private byte[] buffer;
    private int buflen;

    public LookbackBuffer(int size) {
        this.sz = size;
        this.buffer = new byte[this.sz];
        this.buflen = 0;
    }

    public byte[] getLookback() {
        return this.buffer;
    }

    public int available() {
        return this.buflen;
    }

    public void put(byte[] data, int start, int length) {
        int final_sz = this.buflen + length;
        if (final_sz <= this.sz) {
            System.arraycopy(data, start, this.buffer, this.buflen, length);
            this.buflen = final_sz;
            return;
        }
        int new_start = final_sz - this.sz;
        int oldblock_len = this.buflen - new_start;
        if (oldblock_len >= 0) {
            System.arraycopy(this.buffer, new_start, this.buffer, 0, oldblock_len);
        }
        int newblock_len = Math.min(length, this.sz);
        int newblock_src_start = start + length - newblock_len;
        System.arraycopy(data, newblock_src_start, this.buffer, Math.max(0, oldblock_len), newblock_len);
        this.buflen = Math.min(final_sz, this.sz);
    }
}

