/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.annoy.jni.base;

import com.google.common.base.Preconditions;
import com.spotify.annoy.jni.base.AnnoyIndex;
import com.spotify.annoy.jni.base.AnnoyIndexImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class Annoy {
    static final String ANNOY_LIB_PATH = Annoy.extractAnnoyBinaries();

    public static Builder newIndex(int dim, Metric metric) {
        return new Builder(dim, metric);
    }

    public static Builder newIndex(int dim) {
        return new Builder(dim, Metric.ANGULAR);
    }

    public static AnnoyIndex loadIndex(String filename, int dim) throws FileNotFoundException {
        return Annoy.loadIndex(filename, dim, Metric.ANGULAR, 42);
    }

    public static AnnoyIndex loadIndex(String filename, int dim, Metric metric) throws FileNotFoundException {
        return Annoy.loadIndex(filename, dim, metric, 42);
    }

    public static AnnoyIndex loadIndex(String filename, int dim, Metric metric, int rngSeed) throws FileNotFoundException {
        return new AnnoyIndexImpl(dim, metric).setSeed(rngSeed).load(filename);
    }

    private static String extractAnnoyBinaries() {
        String libname = System.mapLibraryName("annoy");
        String libPath = String.format("/%s/%s", Annoy.platform(), libname);
        InputStream annoy = AnnoyIndexImpl.class.getResourceAsStream(libPath);
        try {
            Path tempAnnoy = Files.createTempDirectory("", new FileAttribute[0]).resolve(libname);
            Files.copy(annoy, tempAnnoy, new CopyOption[0]);
            tempAnnoy.toFile().deleteOnExit();
            return tempAnnoy.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String platform() {
        String osArch = System.getProperty("os.arch");
        Preconditions.checkState((boolean)osArch.contains("64"), (Object)"Annoy java only supports x64 arch at the moment");
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("mac")) {
            return "mac-x64";
        }
        if (osName.contains("linux")) {
            return "linux-x64";
        }
        throw new RuntimeException("Annoy-java only runs on Mac and Linux at the moment");
    }

    public static class Builder {
        private final AnnoyIndexImpl ann;

        private Builder(int dim, Metric angular) {
            this.ann = new AnnoyIndexImpl(dim, angular);
        }

        public Builder addItem(int item, List<Float> vector) {
            this.ann.addItem(item, vector);
            return this;
        }

        public Builder addAllItems(Iterable<List<Float>> vectors) {
            this.ann.addAllItems(vectors);
            return this;
        }

        public Builder setSeed(int seed) {
            this.ann.setSeed(seed);
            return this;
        }

        public AnnoyIndex build(int nbTrees) {
            return this.ann.build(nbTrees);
        }
    }

    public static enum Metric {
        ANGULAR,
        EUCLIDEAN;

    }
}

