/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.annoy.jni.base;

import com.spotify.annoy.jni.base.Annoy;
import com.spotify.annoy.jni.base.AnnoyIndex;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

class AnnoyIndexImpl
implements AnnoyIndex {
    private final int dim;
    private final long cppPtr;

    @Override
    public List<Integer> getNearestByVector(List<Float> vector, int nbNeighbors) {
        this.validateVecSize(vector);
        return AnnoyIndexImpl.primitiveToBoxed(this.cppGetNearestByVector(this.cppPtr, AnnoyIndexImpl.boxedToPrimitive(vector), nbNeighbors));
    }

    @Override
    public List<Integer> getNearestByVector(List<Float> vector, int nbNeighbors, int searchK) {
        this.validateVecSize(vector);
        return AnnoyIndexImpl.primitiveToBoxed(this.cppGetNearestByVectorK(this.cppPtr, AnnoyIndexImpl.boxedToPrimitive(vector), nbNeighbors, searchK));
    }

    @Override
    public List<Integer> getNearestByItem(int item, int nbNeighbors) {
        return AnnoyIndexImpl.primitiveToBoxed(this.cppGetNearestByItem(this.cppPtr, item, nbNeighbors));
    }

    @Override
    public List<Integer> getNearestByItem(int item, int nbNeighbors, int searchK) {
        return AnnoyIndexImpl.primitiveToBoxed(this.cppGetNearestByItemK(this.cppPtr, item, nbNeighbors, searchK));
    }

    @Override
    public AnnoyIndex save(String filename) {
        this.cppSave(this.cppPtr, filename);
        return this;
    }

    @Override
    public void close() {
        this.cppDtor(this.cppPtr);
    }

    @Override
    public List<Float> getItemVector(int item) {
        return AnnoyIndexImpl.primitiveToBoxed(this.cppGetItemVector(this.cppPtr, item));
    }

    @Override
    public float getDistance(int itemA, int itemB) {
        return this.cppGetDistance(this.cppPtr, itemA, itemB);
    }

    @Override
    public int size() {
        return this.cppSize(this.cppPtr);
    }

    AnnoyIndexImpl(int dim, Annoy.Metric angular) {
        this.dim = dim;
        System.load(Annoy.ANNOY_LIB_PATH);
        this.cppPtr = this.cppCtor(dim, angular.name().toLowerCase().charAt(0));
    }

    AnnoyIndexImpl addItem(int item, List<Float> vector) {
        this.validateVecSize(vector);
        this.cppAddItem(this.cppPtr, item, AnnoyIndexImpl.boxedToPrimitive(vector));
        return this;
    }

    AnnoyIndexImpl addAllItems(Iterable<List<Float>> vectors) {
        int nb = this.size();
        for (List<Float> vector : vectors) {
            this.addItem(nb++, vector);
        }
        return this;
    }

    AnnoyIndexImpl build(int nbTrees) {
        this.cppBuild(this.cppPtr, nbTrees);
        return this;
    }

    AnnoyIndexImpl load(String filename) throws FileNotFoundException {
        if (Files.notExists(Paths.get(filename, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException("Cannot find annoy index: " + filename);
        }
        this.cppLoad(this.cppPtr, filename);
        return this;
    }

    AnnoyIndexImpl setSeed(int seed) {
        this.cppSetSeed(this.cppPtr, seed);
        return this;
    }

    private static List<Float> primitiveToBoxed(float[] vector) {
        return Arrays.asList(ArrayUtils.toObject((float[])vector));
    }

    private static List<Integer> primitiveToBoxed(int[] vector) {
        return Arrays.asList(ArrayUtils.toObject((int[])vector));
    }

    private static float[] boxedToPrimitive(List<Float> vector) {
        return ArrayUtils.toPrimitive((Float[])vector.toArray(new Float[0]));
    }

    private void validateVecSize(List<Float> vector) {
        if (vector.size() != this.dim) {
            throw new RuntimeException("Item's vector should match the dimension of the tree");
        }
    }

    private native long cppCtor(int var1, int var2);

    private native void cppDtor(long var1);

    private native void cppAddItem(long var1, int var3, float[] var4);

    private native int[] cppGetNearestByVector(long var1, float[] var3, int var4);

    private native int[] cppGetNearestByVectorK(long var1, float[] var3, int var4, int var5);

    private native int[] cppGetNearestByItem(long var1, int var3, int var4);

    private native int[] cppGetNearestByItemK(long var1, int var3, int var4, int var5);

    private native void cppBuild(long var1, int var3);

    private native void cppSave(long var1, String var3);

    private native void cppLoad(long var1, String var3);

    private native float[] cppGetItemVector(long var1, int var3);

    private native float cppGetDistance(long var1, int var3, int var4);

    private native int cppSize(long var1);

    private native void cppSetSeed(long var1, int var3);
}

