/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.annoy.jni.str;

import com.spotify.annoy.jni.base.Annoy;
import com.spotify.annoy.jni.base.AnnoyIndex;
import com.spotify.annoy.jni.str.AnnoyStrIndex;
import com.spotify.annoy.jni.str.AnnoyStrIndexBuilder;
import com.spotify.annoy.jni.str.AnnoyStrIndexImpl;
import com.spotify.sparkey.Sparkey;
import com.spotify.sparkey.SparkeyReader;
import com.spotify.sparkey.SparkeyWriter;
import com.spotify.sparkey.extra.ThreadLocalSparkeyReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

class AnnoyStrIndexBuilderImpl
implements AnnoyStrIndexBuilder {
    private static final String annoyIndexFilename = "annoy.tree";
    private static final String idToStrIndexFilename = "idToStrIndex";
    private static final String strToIdIndexFilename = "strToIdIndex";
    private final String dirName;
    private final Annoy.Builder annoyBuilder;
    private final SparkeyWriter idToStrIndexWriter;
    private final SparkeyWriter strToIdIndexWriter;
    private int itemCount = 0;

    private File getIdToStrIndexPath() {
        return Paths.get(this.dirName, idToStrIndexFilename).toFile();
    }

    private File getStrToIdIndexPath() {
        return Paths.get(this.dirName, strToIdIndexFilename).toFile();
    }

    AnnoyStrIndexBuilderImpl(String dirName, int dim, Annoy.Metric metric) throws IOException {
        this.dirName = dirName;
        this.annoyBuilder = Annoy.newIndex(dim, metric);
        this.idToStrIndexWriter = Sparkey.createNew((File)this.getIdToStrIndexPath());
        this.strToIdIndexWriter = Sparkey.createNew((File)this.getStrToIdIndexPath());
    }

    @Override
    public AnnoyStrIndexBuilder addItem(String key, List<Float> vector) throws IOException {
        Integer id = this.itemCount++;
        this.idToStrIndexWriter.put(id.toString(), key);
        this.strToIdIndexWriter.put(key, id.toString());
        this.annoyBuilder.addItem(id, vector);
        return this;
    }

    @Override
    public AnnoyStrIndexBuilder setSeed(int seed) {
        this.annoyBuilder.setSeed(seed);
        return this;
    }

    @Override
    public AnnoyStrIndex build(int nbTrees) throws IOException {
        this.idToStrIndexWriter.writeHash();
        this.idToStrIndexWriter.close();
        this.strToIdIndexWriter.writeHash();
        this.strToIdIndexWriter.close();
        Path annoyPath = Paths.get(this.dirName, annoyIndexFilename);
        AnnoyIndex annoyIndex = this.annoyBuilder.build(nbTrees).save(annoyPath.toString());
        return new AnnoyStrIndexImpl(annoyIndex, (SparkeyReader)new ThreadLocalSparkeyReader(this.getIdToStrIndexPath()), (SparkeyReader)new ThreadLocalSparkeyReader(this.getStrToIdIndexPath()));
    }

    static AnnoyStrIndex loadIndex(String dirName, int dim) throws IOException {
        return AnnoyStrIndexBuilderImpl.loadIndex(dirName, dim, Annoy.Metric.ANGULAR);
    }

    static AnnoyStrIndex loadIndex(String dirName, int dim, Annoy.Metric metric) throws IOException {
        Path annoyPath = Paths.get(dirName, annoyIndexFilename);
        AnnoyIndex annoyIndex = Annoy.loadIndex(annoyPath.toString(), dim, metric);
        Path idToStrIndexPath = Paths.get(dirName, idToStrIndexFilename);
        ThreadLocalSparkeyReader idToStrIndex = new ThreadLocalSparkeyReader(idToStrIndexPath.toFile());
        Path strToIdIndexPath = Paths.get(dirName, strToIdIndexFilename);
        ThreadLocalSparkeyReader strToIdIndex = new ThreadLocalSparkeyReader(strToIdIndexPath.toFile());
        return new AnnoyStrIndexImpl(annoyIndex, (SparkeyReader)idToStrIndex, (SparkeyReader)strToIdIndex);
    }
}

