/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.annoy.jni.str;

import com.spotify.annoy.jni.base.AnnoyIndex;
import com.spotify.annoy.jni.str.AnnoyStrIndex;
import com.spotify.sparkey.SparkeyReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class AnnoyStrIndexImpl
implements AnnoyStrIndex {
    private final AnnoyIndex annoyIndex;
    private final SparkeyReader idToStrIndex;
    private final SparkeyReader strToIdIndex;

    AnnoyStrIndexImpl(AnnoyIndex annoyIndex, SparkeyReader idToStrIndex, SparkeyReader strToIdIndex) {
        this.annoyIndex = annoyIndex;
        this.idToStrIndex = idToStrIndex;
        this.strToIdIndex = strToIdIndex;
    }

    @Override
    public List<String> getNearestByVector(List<Float> vector, int nbNeighbors) {
        return this.idToStr(this.annoyIndex.getNearestByVector(vector, nbNeighbors));
    }

    @Override
    public List<String> getNearestByVector(List<Float> vector, int nbNeighbors, int searchK) {
        return this.idToStr(this.annoyIndex.getNearestByVector(vector, nbNeighbors, searchK));
    }

    @Override
    public List<String> getNearestByItem(String item, int nbNeighbors) {
        return this.idToStr(this.annoyIndex.getNearestByItem(this.strToId(item), nbNeighbors));
    }

    @Override
    public List<String> getNearestByItem(String item, int nbNeighbors, int searchK) {
        return this.idToStr(this.annoyIndex.getNearestByItem(this.strToId(item), nbNeighbors, searchK));
    }

    @Override
    public List<Float> getItemVector(String item) {
        return this.annoyIndex.getItemVector(this.strToId(item));
    }

    @Override
    public float getDistance(String itemA, String itemB) {
        return this.annoyIndex.getDistance(this.strToId(itemA), this.strToId(itemB));
    }

    @Override
    public int size() {
        return this.annoyIndex.size();
    }

    private List<String> idToStr(List<Integer> ids) {
        ArrayList<String> strs = new ArrayList<String>(ids.size());
        for (Integer id : ids) {
            try {
                String str = id.toString();
                if (str == null) {
                    throw new IndexOutOfBoundsException("Key missing from Sparkey Index: " + id.toString());
                }
                strs.add(this.idToStrIndex.getAsString(str));
            }
            catch (IOException e) {
                throw new RuntimeException("Shit, ", e);
            }
        }
        return strs;
    }

    private Integer strToId(String str) {
        try {
            String idx = this.strToIdIndex.getAsString(str);
            if (idx == null) {
                throw new IndexOutOfBoundsException("Key missing from Sparkey Index: " + str);
            }
            return Integer.valueOf(idx);
        }
        catch (IOException e) {
            throw new RuntimeException("Shit, ", e);
        }
    }
}

