/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.spotify.apollo.AutoValue_Headers;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@AutoValue
abstract class Headers {
    static Headers EMPTY = Headers.create(Collections.emptyMap());

    Headers() {
    }

    static Headers create(Map<String, String> headers) {
        ArrayList headersList = new ArrayList(headers.size());
        headers.entrySet().forEach(h -> Headers.insertOrReplace(headersList, h));
        return new AutoValue_Headers((ImmutableList<Map.Entry<String, String>>)ImmutableList.copyOf(headersList));
    }

    public Optional<String> get(String name) {
        Objects.requireNonNull(name, "Header names cannot be null");
        for (int i = 0; i < this.entries().size(); ++i) {
            Map.Entry headerEntry = (Map.Entry)this.entries().get(i);
            if (!name.equalsIgnoreCase((String)headerEntry.getKey())) continue;
            return Optional.ofNullable((String)headerEntry.getValue());
        }
        return Optional.empty();
    }

    public Map<String, String> asMap() {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        this.entries().forEach(arg_0 -> ((ImmutableMap.Builder)headers).put(arg_0));
        return headers.build();
    }

    public abstract ImmutableList<Map.Entry<String, String>> entries();

    private static void insertOrReplace(List<Map.Entry<String, String>> headerList, Map.Entry<String, String> newHeader) {
        for (int i = 0; i < headerList.size(); ++i) {
            Map.Entry<String, String> currentHeader = headerList.get(i);
            if (!currentHeader.getKey().equalsIgnoreCase(newHeader.getKey())) continue;
            headerList.set(i, new AbstractMap.SimpleImmutableEntry<String, String>(newHeader));
            return;
        }
        headerList.add(new AbstractMap.SimpleImmutableEntry<String, String>(newHeader));
    }
}

