/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.spotify.apollo.ResponseImpl;
import com.spotify.apollo.StatusType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public interface Response<T> {
    public StatusType status();

    @Deprecated
    public Map<String, String> headers();

    public List<Map.Entry<String, String>> headerEntries();

    default public Optional<String> header(String name) {
        Objects.requireNonNull(name, "Header names cannot be null");
        for (Map.Entry<String, String> headerEntry : this.headerEntries()) {
            if (!name.equalsIgnoreCase(headerEntry.getKey())) continue;
            return Optional.ofNullable(headerEntry.getValue());
        }
        return Optional.empty();
    }

    public Optional<T> payload();

    public Response<T> withHeader(String var1, String var2);

    public Response<T> withHeaders(Map<String, String> var1);

    public <P> Response<P> withPayload(@Nullable P var1);

    public static <T> Response<T> ok() {
        return ResponseImpl.OK;
    }

    public static <T> Response<T> forStatus(StatusType statusCode) {
        return ResponseImpl.create(statusCode);
    }

    public static <T> Response<T> forPayload(T payload) {
        return ResponseImpl.create(payload);
    }

    public static <T> Response<T> of(StatusType statusCode, T payload) {
        return ResponseImpl.create(statusCode, payload);
    }
}

