/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.google.auto.value.AutoValue;
import com.spotify.apollo.AutoValue_ResponseImpl;
import com.spotify.apollo.Headers;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
abstract class ResponseImpl<T>
implements Response<T> {
    static final Response<?> OK = ResponseImpl.createInternal(Status.OK, Optional.empty());

    ResponseImpl() {
    }

    @Override
    @Deprecated
    public Map<String, String> headers() {
        return this.internalHeadersImpl().asMap();
    }

    @Override
    public List<Map.Entry<String, String>> headerEntries() {
        return this.internalHeadersImpl().entries();
    }

    @Override
    public Optional<String> header(String name) {
        return this.internalHeadersImpl().get(name);
    }

    abstract Headers internalHeadersImpl();

    @Override
    public Response<T> withHeader(String header, String value) {
        LinkedHashMap<String, String> newHeaders = new LinkedHashMap<String, String>();
        newHeaders.putAll(this.headers());
        newHeaders.put(header, value);
        return ResponseImpl.createInternal(this.status(), Headers.create(newHeaders), this.payload());
    }

    @Override
    public Response<T> withHeaders(Map<String, String> headers) {
        LinkedHashMap<String, String> newHeaders = new LinkedHashMap<String, String>();
        newHeaders.putAll(this.headers());
        newHeaders.putAll(headers);
        return ResponseImpl.createInternal(this.status(), Headers.create(newHeaders), this.payload());
    }

    @Override
    public <P> Response<P> withPayload(@Nullable P newPayload) {
        return ResponseImpl.createInternal(this.status(), this.internalHeadersImpl(), Optional.ofNullable(newPayload));
    }

    static <T> Response<T> create(StatusType statusCode) {
        Objects.requireNonNull(statusCode);
        return statusCode == Status.OK ? OK : ResponseImpl.createInternal(statusCode, Optional.empty());
    }

    static <T> Response<T> create(StatusType statusCode, T payload) {
        Objects.requireNonNull(statusCode);
        return ResponseImpl.createInternal(statusCode, Optional.of(payload));
    }

    static <T> Response<T> create(T payload) {
        return ResponseImpl.createInternal(Status.OK, Optional.of(payload));
    }

    private static <T> Response<T> createInternal(StatusType statusCode, Optional<T> payload) {
        return ResponseImpl.createInternal(statusCode, Headers.EMPTY, payload);
    }

    private static <T> Response<T> createInternal(StatusType statusCode, Headers headers, Optional<T> payload) {
        return new AutoValue_ResponseImpl<T>(statusCode, payload, headers);
    }
}

