/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.spotify.apollo.AutoValue_RequestValue;
import com.spotify.apollo.Headers;
import com.spotify.apollo.QueryStringDecoder;
import com.spotify.apollo.Request;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okio.ByteString;

@AutoValue
abstract class RequestValue
implements Request {
    public static final String GET = "GET";

    RequestValue() {
    }

    public static Request create(String uri) {
        return RequestValue.create(uri, GET);
    }

    public static Request create(String uri, String method) {
        return RequestValue.create(method, uri, RequestValue.parseParameters(uri), Headers.EMPTY, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static Request create(String method, String uri, Map<String, List<String>> parameters, Headers headers, Optional<String> service, Optional<ByteString> payload, Optional<Duration> ttl) {
        return new AutoValue_RequestValue(method, uri, (Map<String, List<String>>)ImmutableMap.copyOf(parameters), service, payload, headers, ttl);
    }

    @Override
    @Deprecated
    public Map<String, String> headers() {
        return this.internalHeadersImpl().asMap();
    }

    @Override
    public List<Map.Entry<String, String>> headerEntries() {
        return this.internalHeadersImpl().entries();
    }

    @Override
    public Optional<String> header(String name) {
        return this.internalHeadersImpl().get(name);
    }

    abstract Headers internalHeadersImpl();

    @Override
    public abstract Optional<Duration> ttl();

    @Override
    public Request withUri(String uri) {
        return RequestValue.create(this.method(), uri, this.parameters(), this.internalHeadersImpl(), this.service(), this.payload(), this.ttl());
    }

    @Override
    public Request withService(String service) {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), this.internalHeadersImpl(), Optional.of(service), this.payload(), this.ttl());
    }

    @Override
    public Request withHeader(String name, String value) {
        return this.withHeaders((Map<String, String>)ImmutableMap.of((Object)name, (Object)value));
    }

    @Override
    public Request withHeaders(Map<String, String> additionalHeaders) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(this.internalHeadersImpl().asMap());
        headers.putAll(additionalHeaders);
        return RequestValue.create(this.method(), this.uri(), this.parameters(), Headers.create(headers), this.service(), this.payload(), this.ttl());
    }

    @Override
    public Request clearHeaders() {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), Headers.EMPTY, this.service(), this.payload(), this.ttl());
    }

    @Override
    public Request withPayload(ByteString payload) {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), this.internalHeadersImpl(), this.service(), Optional.of(payload), this.ttl());
    }

    @Override
    public Request withTtl(Duration duration) {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), this.internalHeadersImpl(), this.service(), this.payload(), Optional.of(duration));
    }

    private static Map<String, List<String>> parseParameters(String uri) {
        return new QueryStringDecoder(uri).parameters();
    }
}

