/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

public interface StatusType {
    public int code();

    public String reasonPhrase();

    public Family family();

    public StatusType withReasonPhrase(String var1);

    public static enum Family {
        INFORMATIONAL,
        SUCCESSFUL,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR,
        OTHER;


        public static Family familyOf(int statusCode) {
            switch (statusCode / 100) {
                case 1: {
                    return INFORMATIONAL;
                }
                case 2: {
                    return SUCCESSFUL;
                }
                case 3: {
                    return REDIRECTION;
                }
                case 4: {
                    return CLIENT_ERROR;
                }
                case 5: {
                    return SERVER_ERROR;
                }
            }
            return OTHER;
        }

        public String rangeName() {
            switch (this) {
                case INFORMATIONAL: {
                    return "1xx";
                }
                case SUCCESSFUL: {
                    return "2xx";
                }
                case REDIRECTION: {
                    return "3xx";
                }
                case CLIENT_ERROR: {
                    return "4xx";
                }
                case SERVER_ERROR: {
                    return "5xx";
                }
            }
            return "unknown";
        }
    }
}

