/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.spotify.apollo.RequestContext;
import com.spotify.apollo.route.SyncHandler;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

@FunctionalInterface
public interface AsyncHandler<T> {
    public CompletionStage<T> invoke(RequestContext var1);

    default public <V> AsyncHandler<V> map(Function<? super T, ? extends V> mapFunction) {
        return requestContext -> this.invoke(requestContext).thenApply(mapFunction);
    }

    default public <V> AsyncHandler<V> flatMap(Function<? super T, ? extends AsyncHandler<? extends V>> mapFunction) {
        return requestContext -> this.invoke(requestContext).thenCompose(t -> ((AsyncHandler)mapFunction.apply(t)).invoke(requestContext));
    }

    default public <V> AsyncHandler<V> flatMapSync(Function<? super T, ? extends SyncHandler<? extends V>> mapFunction) {
        return requestContext -> this.invoke(requestContext).thenApply(t -> ((SyncHandler)mapFunction.apply(t)).invoke(requestContext));
    }
}

