/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableList;
import com.spotify.asyncdatastoreclient.Key;
import com.spotify.asyncdatastoreclient.Result;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class AllocateIdsResult
implements Result {
    private final List<Key> keys;

    private AllocateIdsResult() {
        this.keys = ImmutableList.of();
    }

    private AllocateIdsResult(List<DatastoreV1.Key> keys) {
        this.keys = ImmutableList.copyOf((Collection)keys.stream().map(key -> Key.builder(key).build()).collect(Collectors.toList()));
    }

    static AllocateIdsResult build(DatastoreV1.AllocateIdsResponse response) {
        return new AllocateIdsResult(response.getKeyList());
    }

    public static AllocateIdsResult build() {
        return new AllocateIdsResult();
    }

    public List<Key> getKeys() {
        return this.keys;
    }
}

