/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.protobuf.ProtoHttpContent;
import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.extra.ListenableFutureAdapter;
import com.spotify.asyncdatastoreclient.AllocateIds;
import com.spotify.asyncdatastoreclient.AllocateIdsResult;
import com.spotify.asyncdatastoreclient.DatastoreConfig;
import com.spotify.asyncdatastoreclient.DatastoreException;
import com.spotify.asyncdatastoreclient.KeyQuery;
import com.spotify.asyncdatastoreclient.MutationResult;
import com.spotify.asyncdatastoreclient.MutationStatement;
import com.spotify.asyncdatastoreclient.Query;
import com.spotify.asyncdatastoreclient.QueryResult;
import com.spotify.asyncdatastoreclient.RollbackResult;
import com.spotify.asyncdatastoreclient.TransactionResult;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datastore
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Datastore.class);
    public static final String VERSION = "1.0.0";
    public static final String USER_AGENT = "Datastore-Java-Client/1.0.0 (gzip)";
    private final DatastoreConfig config;
    private final AsyncHttpClient client;
    private final String prefixUri;
    private ScheduledExecutorService executor;
    private volatile String accessToken;

    private Datastore(DatastoreConfig config) {
        this.config = config;
        AsyncHttpClientConfig httpConfig = new AsyncHttpClientConfig.Builder().setConnectTimeout(config.getConnectTimeout()).setRequestTimeout(config.getRequestTimeout()).setMaxConnections(config.getMaxConnections()).setMaxRequestRetry(config.getRequestRetry()).setCompressionEnforced(true).build();
        this.client = new AsyncHttpClient(httpConfig);
        this.prefixUri = String.format("%s/datastore/%s/datasets/%s/", config.getHost(), config.getVersion(), config.getDataset());
        this.executor = Executors.newSingleThreadScheduledExecutor();
        if (config.getCredential() != null) {
            this.refreshAccessToken();
            this.executor.scheduleAtFixedRate(this::refreshAccessToken, 10L, 10L, TimeUnit.SECONDS);
        }
    }

    public static Datastore create(DatastoreConfig config) {
        return new Datastore(config);
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.client.close();
    }

    private void refreshAccessToken() {
        Credential credential = this.config.getCredential();
        Long expiresIn = credential.getExpiresInSeconds();
        if (credential.getAccessToken() == null || expiresIn != null && expiresIn <= 60L) {
            try {
                credential.refreshToken();
                String accessToken = credential.getAccessToken();
                if (accessToken != null) {
                    this.accessToken = accessToken;
                }
            }
            catch (IOException e) {
                log.error("Storage exception", Throwables.getRootCause((Throwable)e));
            }
        }
    }

    private boolean isSuccessful(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private AsyncHttpClient.BoundRequestBuilder prepareRequest(String method, ProtoHttpContent payload) throws IOException {
        AsyncHttpClient.BoundRequestBuilder builder = this.client.preparePost(this.prefixUri + method);
        builder.addHeader("Authorization", "Bearer " + this.accessToken);
        builder.addHeader("Content-Type", "application/x-protobuf");
        builder.addHeader("User-Agent", USER_AGENT);
        builder.addHeader("Accept-Encoding", "gzip");
        builder.setContentLength((int)payload.getLength());
        builder.setBody(payload.getMessage().toByteArray());
        return builder;
    }

    private InputStream streamResponse(Response response) throws IOException {
        InputStream input = response.getResponseBodyAsStream();
        boolean compressed = "gzip".equals(response.getHeader("Content-Encoding"));
        return compressed ? new GZIPInputStream(input) : input;
    }

    public TransactionResult transaction() throws DatastoreException {
        return (TransactionResult)Futures.get(this.transactionAsync(IsolationLevel.SNAPSHOT), DatastoreException.class);
    }

    public TransactionResult transaction(IsolationLevel isolationLevel) throws DatastoreException {
        return (TransactionResult)Futures.get(this.transactionAsync(isolationLevel), DatastoreException.class);
    }

    public ListenableFuture<TransactionResult> transactionAsync() {
        return this.transactionAsync(IsolationLevel.SNAPSHOT);
    }

    public ListenableFuture<TransactionResult> transactionAsync(IsolationLevel isolationLevel) {
        ListenableFuture httpResponse;
        try {
            DatastoreV1.BeginTransactionRequest.Builder request = DatastoreV1.BeginTransactionRequest.newBuilder();
            if (isolationLevel == IsolationLevel.SERIALIZABLE) {
                request.setIsolationLevel(DatastoreV1.BeginTransactionRequest.IsolationLevel.SERIALIZABLE);
            } else {
                request.setIsolationLevel(DatastoreV1.BeginTransactionRequest.IsolationLevel.SNAPSHOT);
            }
            ProtoHttpContent payload = new ProtoHttpContent((MessageLite)request.build());
            httpResponse = ListenableFutureAdapter.asGuavaFuture((com.ning.http.client.ListenableFuture)this.prepareRequest("beginTransaction", payload).execute());
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)new DatastoreException(e));
        }
        return Futures.transform((ListenableFuture)httpResponse, response -> {
            if (!this.isSuccessful(response.getStatusCode())) {
                throw new DatastoreException(response.getStatusCode(), response.getResponseBody());
            }
            DatastoreV1.BeginTransactionResponse transaction = DatastoreV1.BeginTransactionResponse.parseFrom((InputStream)this.streamResponse((Response)response));
            return Futures.immediateFuture((Object)TransactionResult.build(transaction));
        });
    }

    public RollbackResult rollback(TransactionResult txn) throws DatastoreException {
        return (RollbackResult)Futures.get(this.rollbackAsync((ListenableFuture<TransactionResult>)Futures.immediateFuture((Object)txn)), DatastoreException.class);
    }

    public ListenableFuture<RollbackResult> rollbackAsync(ListenableFuture<TransactionResult> txn) {
        ListenableFuture httpResponse = Futures.transform(txn, result -> {
            DatastoreV1.RollbackRequest.Builder request = DatastoreV1.RollbackRequest.newBuilder();
            ByteString transaction = result.getTransaction();
            if (transaction == null) {
                throw new DatastoreException("Invalid transaction.");
            }
            ProtoHttpContent payload = new ProtoHttpContent((MessageLite)request.build());
            return ListenableFutureAdapter.asGuavaFuture((com.ning.http.client.ListenableFuture)this.prepareRequest("rollback", payload).execute());
        });
        return Futures.transform((ListenableFuture)httpResponse, response -> {
            if (!this.isSuccessful(response.getStatusCode())) {
                throw new DatastoreException(response.getStatusCode(), response.getResponseBody());
            }
            DatastoreV1.RollbackResponse rollback = DatastoreV1.RollbackResponse.parseFrom((InputStream)this.streamResponse((Response)response));
            return Futures.immediateFuture((Object)RollbackResult.build(rollback));
        });
    }

    public MutationResult commit(TransactionResult txn) throws DatastoreException {
        return (MutationResult)Futures.get(this.executeAsync((MutationStatement)null, (ListenableFuture<TransactionResult>)Futures.immediateFuture((Object)txn)), DatastoreException.class);
    }

    public ListenableFuture<MutationResult> commitAsync(ListenableFuture<TransactionResult> txn) {
        return this.executeAsync((MutationStatement)null, txn);
    }

    public AllocateIdsResult execute(AllocateIds statement) throws DatastoreException {
        return (AllocateIdsResult)Futures.get(this.executeAsync(statement), DatastoreException.class);
    }

    public ListenableFuture<AllocateIdsResult> executeAsync(AllocateIds statement) {
        ListenableFuture httpResponse;
        try {
            DatastoreV1.AllocateIdsRequest.Builder request = DatastoreV1.AllocateIdsRequest.newBuilder().addAllKey(statement.getPb(this.config.getNamespace()));
            ProtoHttpContent payload = new ProtoHttpContent((MessageLite)request.build());
            httpResponse = ListenableFutureAdapter.asGuavaFuture((com.ning.http.client.ListenableFuture)this.prepareRequest("allocateIds", payload).execute());
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)new DatastoreException(e));
        }
        return Futures.transform((ListenableFuture)httpResponse, response -> {
            if (!this.isSuccessful(response.getStatusCode())) {
                throw new DatastoreException(response.getStatusCode(), response.getResponseBody());
            }
            DatastoreV1.AllocateIdsResponse allocate = DatastoreV1.AllocateIdsResponse.parseFrom((InputStream)this.streamResponse((Response)response));
            return Futures.immediateFuture((Object)AllocateIdsResult.build(allocate));
        });
    }

    public QueryResult execute(KeyQuery statement) throws DatastoreException {
        return (QueryResult)Futures.get(this.executeAsync(statement), DatastoreException.class);
    }

    public ListenableFuture<QueryResult> executeAsync(KeyQuery statement) {
        return this.executeAsync(statement, (ListenableFuture<TransactionResult>)Futures.immediateFuture((Object)TransactionResult.build()));
    }

    public QueryResult execute(KeyQuery statement, TransactionResult txn) throws DatastoreException {
        return (QueryResult)Futures.get(this.executeAsync(statement, (ListenableFuture<TransactionResult>)Futures.immediateFuture((Object)txn)), DatastoreException.class);
    }

    public ListenableFuture<QueryResult> executeAsync(KeyQuery statement, ListenableFuture<TransactionResult> txn) {
        ListenableFuture httpResponse = Futures.transform(txn, result -> {
            DatastoreV1.Key key = statement.getKey().getPb(this.config.getNamespace());
            DatastoreV1.LookupRequest.Builder request = DatastoreV1.LookupRequest.newBuilder().addKey(key);
            ByteString transaction = result.getTransaction();
            if (transaction != null) {
                request.setReadOptions(DatastoreV1.ReadOptions.newBuilder().setTransaction(transaction));
            }
            ProtoHttpContent payload = new ProtoHttpContent((MessageLite)request.build());
            return ListenableFutureAdapter.asGuavaFuture((com.ning.http.client.ListenableFuture)this.prepareRequest("lookup", payload).execute());
        });
        return Futures.transform((ListenableFuture)httpResponse, response -> {
            if (!this.isSuccessful(response.getStatusCode())) {
                throw new DatastoreException(response.getStatusCode(), response.getResponseBody());
            }
            DatastoreV1.LookupResponse query = DatastoreV1.LookupResponse.parseFrom((InputStream)this.streamResponse((Response)response));
            return Futures.immediateFuture((Object)QueryResult.build(query));
        });
    }

    public MutationResult execute(MutationStatement statement) throws DatastoreException {
        return (MutationResult)Futures.get(this.executeAsync(statement), DatastoreException.class);
    }

    public ListenableFuture<MutationResult> executeAsync(MutationStatement statement) {
        return this.executeAsync(statement, (ListenableFuture<TransactionResult>)Futures.immediateFuture((Object)TransactionResult.build()));
    }

    public MutationResult execute(MutationStatement statement, TransactionResult txn) throws DatastoreException {
        return (MutationResult)Futures.get(this.executeAsync(statement, (ListenableFuture<TransactionResult>)Futures.immediateFuture((Object)txn)), DatastoreException.class);
    }

    public ListenableFuture<MutationResult> executeAsync(MutationStatement statement, ListenableFuture<TransactionResult> txn) {
        ListenableFuture httpResponse = Futures.transform(txn, result -> {
            ByteString transaction;
            DatastoreV1.CommitRequest.Builder request = DatastoreV1.CommitRequest.newBuilder();
            if (statement != null) {
                request.setMutation(statement.getPb(this.config.getNamespace()));
            }
            if ((transaction = result.getTransaction()) != null) {
                request.setTransaction(transaction);
            } else {
                request.setMode(DatastoreV1.CommitRequest.Mode.NON_TRANSACTIONAL);
            }
            ProtoHttpContent payload = new ProtoHttpContent((MessageLite)request.build());
            return ListenableFutureAdapter.asGuavaFuture((com.ning.http.client.ListenableFuture)this.prepareRequest("commit", payload).execute());
        });
        return Futures.transform((ListenableFuture)httpResponse, response -> {
            if (!this.isSuccessful(response.getStatusCode())) {
                throw new DatastoreException(response.getStatusCode(), response.getResponseBody());
            }
            DatastoreV1.CommitResponse commit = DatastoreV1.CommitResponse.parseFrom((InputStream)this.streamResponse((Response)response));
            return Futures.immediateFuture((Object)MutationResult.build(commit));
        });
    }

    public QueryResult execute(Query statement) throws DatastoreException {
        return (QueryResult)Futures.get(this.executeAsync(statement), DatastoreException.class);
    }

    public ListenableFuture<QueryResult> executeAsync(Query statement) {
        return this.executeAsync(statement, (ListenableFuture<TransactionResult>)Futures.immediateFuture((Object)TransactionResult.build()));
    }

    public QueryResult execute(Query statement, TransactionResult txn) throws DatastoreException {
        return (QueryResult)Futures.get(this.executeAsync(statement, (ListenableFuture<TransactionResult>)Futures.immediateFuture((Object)txn)), DatastoreException.class);
    }

    public ListenableFuture<QueryResult> executeAsync(Query statement, ListenableFuture<TransactionResult> txn) {
        ListenableFuture httpResponse = Futures.transform(txn, result -> {
            ByteString transaction;
            DatastoreV1.RunQueryRequest.Builder request = DatastoreV1.RunQueryRequest.newBuilder().setQuery(statement.getPb());
            String namespace = this.config.getNamespace();
            if (namespace != null) {
                request.setPartitionId(DatastoreV1.PartitionId.newBuilder().setNamespace(namespace));
            }
            if ((transaction = result.getTransaction()) != null) {
                request.setReadOptions(DatastoreV1.ReadOptions.newBuilder().setTransaction(transaction));
            }
            ProtoHttpContent payload = new ProtoHttpContent((MessageLite)request.build());
            return ListenableFutureAdapter.asGuavaFuture((com.ning.http.client.ListenableFuture)this.prepareRequest("runQuery", payload).execute());
        });
        return Futures.transform((ListenableFuture)httpResponse, response -> {
            if (!this.isSuccessful(response.getStatusCode())) {
                throw new DatastoreException(response.getStatusCode(), response.getResponseBody());
            }
            DatastoreV1.RunQueryResponse query = DatastoreV1.RunQueryResponse.parseFrom((InputStream)this.streamResponse((Response)response));
            return Futures.immediateFuture((Object)QueryResult.build(query));
        });
    }

    public static enum IsolationLevel {
        SNAPSHOT,
        SERIALIZABLE;

    }
}

