/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.MoreObjects;

public class DatastoreConfig {
    private static final Integer DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final Integer DEFAULT_MAX_CONNECTIONS = -1;
    private static final Integer DEFAULT_REQUEST_TIMEOUTS = 5000;
    private static final Integer DEFAULT_REQUEST_RETRIES = 5;
    private static final String DEFAULT_HOST = "https://www.googleapis.com";
    private static final String DEFAULT_VERSION = "v1beta2";
    private int connectTimeout;
    private int maxConnections;
    private int requestTimeout;
    private int requestRetry;
    private final Credential credential;
    private final String dataset;
    private final String namespace;
    private final String host;
    private final String version;

    private DatastoreConfig(Integer connectTimeout, Integer maxConnections, Integer requestTimeout, Integer requestRetry, Credential credential, String dataset, String namespace, String host, String version) {
        this.connectTimeout = (Integer)MoreObjects.firstNonNull((Object)connectTimeout, (Object)DEFAULT_CONNECT_TIMEOUT);
        this.maxConnections = (Integer)MoreObjects.firstNonNull((Object)maxConnections, (Object)DEFAULT_MAX_CONNECTIONS);
        this.requestTimeout = (Integer)MoreObjects.firstNonNull((Object)requestTimeout, (Object)DEFAULT_REQUEST_TIMEOUTS);
        this.requestRetry = (Integer)MoreObjects.firstNonNull((Object)requestRetry, (Object)DEFAULT_REQUEST_RETRIES);
        this.credential = credential;
        this.dataset = dataset;
        this.namespace = namespace;
        this.host = (String)MoreObjects.firstNonNull((Object)host, (Object)DEFAULT_HOST);
        this.version = (String)MoreObjects.firstNonNull((Object)version, (Object)DEFAULT_VERSION);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getRequestRetry() {
        return this.requestRetry;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getHost() {
        return this.host;
    }

    public String getVersion() {
        return this.version;
    }

    public static class Builder {
        private Integer connectTimeout;
        private Integer maxConnections;
        private Integer requestTimeout;
        private Integer requestRetry;
        private Credential credential;
        private String dataset;
        private String namespace;
        private String host;
        private String version;

        private Builder() {
        }

        public DatastoreConfig build() {
            return new DatastoreConfig(this.connectTimeout, this.maxConnections, this.requestTimeout, this.requestRetry, this.credential, this.dataset, this.namespace, this.host, this.version);
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder requestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder requestRetry(int requestRetry) {
            this.requestRetry = requestRetry;
            return this;
        }

        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public Builder dataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }
    }
}

