/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.client.util.Maps;
import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableSortedMap;
import com.google.protobuf.ByteString;
import com.spotify.asyncdatastoreclient.Key;
import com.spotify.asyncdatastoreclient.Value;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Entity {
    private final DatastoreV1.Entity entity;
    private Map<String, Value> properties;

    private Entity(DatastoreV1.Entity entity) {
        this.entity = entity;
        this.properties = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String kind) {
        return new Builder(Key.builder(kind).build());
    }

    public static Builder builder(String kind, long id) {
        return new Builder(Key.builder(kind, id).build());
    }

    public static Builder builder(String kind, String name) {
        return new Builder(Key.builder(kind, name).build());
    }

    public static Builder builder(Key key) {
        return new Builder(key);
    }

    public static Builder builder(Entity entity) {
        return new Builder(entity);
    }

    static Builder builder(DatastoreV1.Entity entity) {
        return new Builder(entity);
    }

    public Key getKey() {
        return Key.builder(this.entity.getKey()).build();
    }

    public String getString(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : value.getString();
    }

    public Long getInteger(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : Long.valueOf(value.getInteger());
    }

    public Boolean getBoolean(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : Boolean.valueOf(value.getBoolean());
    }

    public Double getDouble(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : Double.valueOf(value.getDouble());
    }

    public Date getDate(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : value.getDate();
    }

    public ByteString getBlob(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : value.getBlob();
    }

    public Entity getEntity(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : value.getEntity();
    }

    public Key getKey(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : value.getKey();
    }

    public List<Value> getList(String name) {
        Value value = this.getProperties().get(name);
        return value == null ? null : value.getList();
    }

    public <T> List<T> getList(String name, Class<T> clazz) {
        Value value = this.getProperties().get(name);
        return value == null ? null : value.getList(clazz);
    }

    public Map<String, Value> getProperties() {
        if (this.properties == null) {
            this.properties = ImmutableSortedMap.copyOf(this.entity.getPropertyList().stream().collect(Collectors.toMap(DatastoreV1.Property::getName, property -> Value.builder(property.getValue()).build())));
        }
        return this.properties;
    }

    public boolean contains(String name) {
        return this.getProperties().containsKey(name);
    }

    public String toString() {
        return "{" + this.getProperties().entrySet().stream().map(property -> (String)property.getKey() + ":" + property.getValue()).collect(Collectors.joining(", ")) + "}";
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Entity && Objects.equals(this.entity, ((Entity)obj).entity);
    }

    DatastoreV1.Entity getPb() {
        return this.entity;
    }

    DatastoreV1.Entity getPb(String namespace) {
        DatastoreV1.Entity.Builder prepared = DatastoreV1.Entity.newBuilder((DatastoreV1.Entity)this.entity).setKey(this.getKey().getPb(namespace));
        List properties = this.entity.getPropertyList().stream().map(property -> {
            if (property.getValue().hasKeyValue()) {
                return DatastoreV1.Property.newBuilder((DatastoreV1.Property)property).setValue(Value.builder(property.getValue()).build().getPb(namespace)).build();
            }
            return property;
        }).collect(Collectors.toList());
        return prepared.clearProperty().addAllProperty(properties).build();
    }

    public static class Builder {
        private DatastoreV1.Entity.Builder entity;
        private Map<String, Value> properties;

        private Builder() {
            this.entity = DatastoreV1.Entity.newBuilder();
            this.properties = Maps.newHashMap();
        }

        private Builder(Key key) {
            this.entity = DatastoreV1.Entity.newBuilder().setKey(key.getPb());
            this.properties = Maps.newHashMap();
        }

        private Builder(Entity entity) {
            this(entity.getPb());
        }

        private Builder(DatastoreV1.Entity entity) {
            this.entity = DatastoreV1.Entity.newBuilder((DatastoreV1.Entity)entity);
            this.properties = entity.getPropertyList().stream().collect(Collectors.toMap(DatastoreV1.Property::getName, property -> Value.builder(property.getValue()).build()));
        }

        public Entity build() {
            this.entity.clearProperty();
            this.entity.addAllProperty((Iterable)this.properties.entrySet().stream().map(entry -> DatastoreV1.Property.newBuilder().setName((String)entry.getKey()).setValue(((Value)entry.getValue()).getPb()).build()).collect(Collectors.toList()));
            return new Entity(this.entity.build());
        }

        public Builder key(Key key) {
            this.entity.setKey(key.getPb());
            return this;
        }

        public Builder property(String name, Object value) {
            this.properties.put(name, Value.builder(value).build());
            return this;
        }

        public Builder property(String name, Object value, boolean indexed) {
            this.properties.put(name, Value.builder(value).indexed(indexed).build());
            return this;
        }

        public Builder property(String name, List<Object> values) {
            this.properties.put(name, Value.builder(values).build());
            return this;
        }

        public Builder remove(String name) {
            this.properties.remove(name);
            return this;
        }
    }
}

