/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.services.datastore.DatastoreV1;
import com.spotify.asyncdatastoreclient.Value;

public class Filter {
    private final String name;
    private final Operator op;
    private final Value value;

    Filter(String name, Operator op, Value value) {
        this.name = name;
        this.op = op;
        this.value = value;
    }

    DatastoreV1.Filter getPb() {
        DatastoreV1.PropertyFilter.Builder filter = DatastoreV1.PropertyFilter.newBuilder().setProperty(DatastoreV1.PropertyReference.newBuilder().setName(this.name)).setValue(this.value.getPb());
        switch (this.op) {
            case LESS_THAN: {
                filter.setOperator(DatastoreV1.PropertyFilter.Operator.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filter.setOperator(DatastoreV1.PropertyFilter.Operator.LESS_THAN_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                filter.setOperator(DatastoreV1.PropertyFilter.Operator.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filter.setOperator(DatastoreV1.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL);
                break;
            }
            case EQUAL: {
                filter.setOperator(DatastoreV1.PropertyFilter.Operator.EQUAL);
                break;
            }
            case HAS_ANCESTOR: {
                filter.setOperator(DatastoreV1.PropertyFilter.Operator.HAS_ANCESTOR);
            }
        }
        return DatastoreV1.Filter.newBuilder().setPropertyFilter(filter).build();
    }

    public static enum Operator {
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        EQUAL,
        HAS_ANCESTOR;

    }
}

