/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.services.datastore.DatastoreV1;
import com.spotify.asyncdatastoreclient.Entity;
import com.spotify.asyncdatastoreclient.Key;
import com.spotify.asyncdatastoreclient.KeyedStatement;
import com.spotify.asyncdatastoreclient.MutationStatement;
import java.util.List;

public class Insert
extends KeyedStatement
implements MutationStatement {
    protected Entity.Builder entity;

    Insert(Key key) {
        super(key);
        this.entity = Entity.builder(key);
    }

    Insert(Entity entity) {
        super(entity.getKey());
        this.entity = Entity.builder(entity);
    }

    public Insert value(String name, Object value) {
        this.entity.property(name, value);
        return this;
    }

    public Insert value(String name, Object value, boolean indexed) {
        this.entity.property(name, value, indexed);
        return this;
    }

    public Insert value(String name, List<Object> values) {
        this.entity.property(name, values);
        return this;
    }

    @Override
    public DatastoreV1.Mutation getPb(String namespace) {
        DatastoreV1.Mutation.Builder mutation = DatastoreV1.Mutation.newBuilder();
        if (this.getKey().isComplete()) {
            mutation.addInsert(this.entity.build().getPb(namespace));
        } else {
            mutation.addInsertAutoId(this.entity.build().getPb(namespace));
        }
        return mutation.build();
    }
}

