/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Key {
    private final DatastoreV1.Key key;

    private Key(DatastoreV1.Key key) {
        this.key = key;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String kind) {
        return new Builder().path(kind);
    }

    public static Builder builder(String kind, Key parent) {
        return new Builder().parent(parent).path(kind);
    }

    public static Builder builder(String kind, long id) {
        return new Builder().path(kind, id);
    }

    public static Builder builder(String kind, long id, Key parent) {
        return new Builder().parent(parent).path(kind, id);
    }

    public static Builder builder(String kind, String name) {
        return new Builder().path(kind, name);
    }

    public static Builder builder(String kind, String name, Key parent) {
        return new Builder().parent(parent).path(kind, name);
    }

    public static Builder builder(Key key) {
        return new Builder(key);
    }

    static Builder builder(DatastoreV1.Key key) {
        return new Builder(key);
    }

    public String getNamespace() {
        return this.key.hasPartitionId() && this.key.getPartitionId().hasNamespace() ? this.key.getPartitionId().getNamespace() : null;
    }

    public boolean isComplete() {
        if (this.key.getPathElementCount() == 0) {
            return false;
        }
        for (DatastoreV1.Key.PathElement element : this.key.getPathElementList()) {
            if (element.hasId() || element.hasName()) continue;
            return false;
        }
        return true;
    }

    public String getKind() {
        DatastoreV1.Key.PathElement element = (DatastoreV1.Key.PathElement)Iterables.getLast((Iterable)this.key.getPathElementList(), null);
        if (element == null) {
            return null;
        }
        return element.hasKind() ? element.getKind() : null;
    }

    public Long getId() {
        DatastoreV1.Key.PathElement element = (DatastoreV1.Key.PathElement)Iterables.getLast((Iterable)this.key.getPathElementList(), null);
        if (element == null) {
            return null;
        }
        return element.hasId() ? Long.valueOf(element.getId()) : null;
    }

    public String getName() {
        DatastoreV1.Key.PathElement element = (DatastoreV1.Key.PathElement)Iterables.getLast((Iterable)this.key.getPathElementList(), null);
        if (element == null) {
            return null;
        }
        return element.hasName() ? element.getName() : null;
    }

    public List<Element> getPath() {
        return ImmutableList.copyOf((Collection)this.key.getPathElementList().stream().map(x$0 -> new Element((DatastoreV1.Key.PathElement)x$0)).collect(Collectors.toList()));
    }

    public String toString() {
        return "{" + this.getPath().stream().map(Element::toString).collect(Collectors.joining(", ")) + "}";
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Key && Objects.equals(this.key, ((Key)obj).key);
    }

    DatastoreV1.Key getPb() {
        return this.key;
    }

    DatastoreV1.Key getPb(String namespace) {
        if (namespace == null) {
            return this.key;
        }
        return DatastoreV1.Key.newBuilder((DatastoreV1.Key)this.key).setPartitionId(DatastoreV1.PartitionId.newBuilder().setNamespace(namespace)).build();
    }

    public static class Builder {
        private final DatastoreV1.Key.Builder key;

        private Builder() {
            this.key = DatastoreV1.Key.newBuilder();
        }

        private Builder(Key key) {
            this(key.getPb());
        }

        private Builder(DatastoreV1.Key key) {
            this.key = DatastoreV1.Key.newBuilder((DatastoreV1.Key)key);
        }

        public Key build() {
            return new Key(this.key.build());
        }

        public Builder namespace(String namespace) {
            this.key.setPartitionId(DatastoreV1.PartitionId.newBuilder().setNamespace(namespace));
            return this;
        }

        public Builder path(Element element) {
            this.key.addPathElement(element.getPb());
            return this;
        }

        public Builder path(String kind) {
            this.key.addPathElement(DatastoreV1.Key.PathElement.newBuilder().setKind(kind));
            return this;
        }

        public Builder path(String kind, long id) {
            this.key.addPathElement(DatastoreV1.Key.PathElement.newBuilder().setKind(kind).setId(id));
            return this;
        }

        public Builder path(String kind, String name) {
            this.key.addPathElement(DatastoreV1.Key.PathElement.newBuilder().setKind(kind).setName(name));
            return this;
        }

        public Builder parent(Key parent) {
            for (Element element : parent.getPath()) {
                Long id = element.getId();
                String name = element.getName();
                if (id != null) {
                    this.path(element.getKind(), id);
                    continue;
                }
                if (name == null) continue;
                this.path(element.getKind(), name);
            }
            return this;
        }
    }

    public static class Element {
        private final DatastoreV1.Key.PathElement element;

        private Element(DatastoreV1.Key.PathElement element) {
            this.element = element;
        }

        public String getKind() {
            return this.element.hasKind() ? this.element.getKind() : null;
        }

        public Long getId() {
            return this.element.hasId() ? Long.valueOf(this.element.getId()) : null;
        }

        public String getName() {
            return this.element.hasName() ? this.element.getName() : null;
        }

        DatastoreV1.Key.PathElement getPb() {
            return this.element;
        }

        public String toString() {
            Long id = this.getId();
            return this.getKind() + ":" + (id == null ? this.getName() : id);
        }
    }
}

