/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableList;
import com.spotify.asyncdatastoreclient.Key;
import com.spotify.asyncdatastoreclient.Result;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class MutationResult
implements Result {
    private final DatastoreV1.MutationResult result;

    private MutationResult(DatastoreV1.MutationResult result) {
        this.result = result;
    }

    static MutationResult build(DatastoreV1.CommitResponse response) {
        return response.hasMutationResult() ? new MutationResult(response.getMutationResult()) : MutationResult.build();
    }

    public static MutationResult build() {
        return new MutationResult(DatastoreV1.MutationResult.getDefaultInstance());
    }

    public Key getInsertKey() {
        if (this.result.getInsertAutoIdKeyCount() == 0) {
            return null;
        }
        return Key.builder(this.result.getInsertAutoIdKey(0)).build();
    }

    public List<Key> getInsertKeys() {
        return ImmutableList.copyOf((Collection)this.result.getInsertAutoIdKeyList().stream().map(key -> Key.builder(key).build()).collect(Collectors.toList()));
    }

    public int getIndexUpdates() {
        return this.result.getIndexUpdates();
    }
}

