/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.client.util.Lists;
import com.google.api.services.datastore.DatastoreV1;
import com.google.protobuf.ByteString;
import com.spotify.asyncdatastoreclient.Filter;
import com.spotify.asyncdatastoreclient.Group;
import com.spotify.asyncdatastoreclient.Order;
import com.spotify.asyncdatastoreclient.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Query
implements Statement {
    private final DatastoreV1.Query.Builder query = DatastoreV1.Query.newBuilder();
    private final List<DatastoreV1.Filter> filters = Lists.newArrayList();

    Query() {
    }

    public Query keysOnly() {
        this.query.addProjection(DatastoreV1.PropertyExpression.newBuilder().setProperty(DatastoreV1.PropertyReference.newBuilder().setName("__key__")));
        return this;
    }

    public Query properties(String ... properties) {
        return this.properties(Arrays.asList(properties));
    }

    public Query properties(List<String> properties) {
        this.query.addAllProjection((Iterable)properties.stream().map(property -> DatastoreV1.PropertyExpression.newBuilder().setProperty(DatastoreV1.PropertyReference.newBuilder().setName(property)).build()).collect(Collectors.toList()));
        return this;
    }

    public Query kindOf(String kind) {
        this.query.addKind(DatastoreV1.KindExpression.newBuilder().setName(kind).build());
        return this;
    }

    public Query filterBy(Filter filter) {
        this.filters.add(filter.getPb());
        return this;
    }

    public Query orderBy(Order order) {
        this.query.addOrder(order.getPb());
        return this;
    }

    public Query groupBy(Group group) {
        this.query.addGroupBy(group.getPb());
        return this;
    }

    public Query fromCursor(ByteString cursor) {
        this.query.setStartCursor(cursor);
        return this;
    }

    public Query limit(int limit) {
        this.query.setLimit(limit);
        return this;
    }

    DatastoreV1.Query getPb() {
        if (this.filters.size() == 1) {
            this.query.setFilter(this.filters.get(0));
        } else if (this.filters.size() > 1) {
            this.query.setFilter(DatastoreV1.Filter.newBuilder().setCompositeFilter(DatastoreV1.CompositeFilter.newBuilder().addAllFilter(this.filters).setOperator(DatastoreV1.CompositeFilter.Operator.AND)));
        }
        return this.query.build();
    }
}

